/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.flags;

import org.infinispan.AdvancedCache;
import org.infinispan.CacheImpl;
import org.infinispan.DecoratedCache;
import org.infinispan.context.Flag;
import org.infinispan.test.CherryPickClassLoader;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.flags.DecoratedCacheTest")
public class DecoratedCacheTest {
    public void testDecoratedCacheFlagsSet() {
        ClassLoader thisClassLoader = this.getClass().getClassLoader();
        CacheImpl impl = new CacheImpl("baseCache");
        DecoratedCache decoratedCache = new DecoratedCache((AdvancedCache)impl, thisClassLoader);
        DecoratedCache nofailCache = (DecoratedCache)decoratedCache.withFlags(new Flag[]{Flag.FAIL_SILENTLY});
        assert (nofailCache.getFlags().contains(Flag.FAIL_SILENTLY));
        assert (nofailCache.getFlags().size() == 1);
        DecoratedCache asyncNoFailCache = (DecoratedCache)nofailCache.withFlags(new Flag[]{Flag.FORCE_ASYNCHRONOUS});
        assert (asyncNoFailCache.getFlags().size() == 2);
        assert (asyncNoFailCache.getFlags().contains(Flag.FAIL_SILENTLY));
        assert (asyncNoFailCache.getFlags().contains(Flag.FORCE_ASYNCHRONOUS));
        AdvancedCache again = asyncNoFailCache.withFlags(new Flag[]{Flag.FAIL_SILENTLY});
        assert (again == asyncNoFailCache);
        CherryPickClassLoader cl = new CherryPickClassLoader(null, null, null, thisClassLoader);
        assert (again.getClassLoader() == thisClassLoader);
        DecoratedCache clCache = (DecoratedCache)again.with((ClassLoader)cl);
        assert (clCache.getClassLoader() == cl);
        assert (clCache.getFlags().size() == 2);
        assert (again.getClassLoader() == thisClassLoader);
        assert (decoratedCache.getFlags() == null || decoratedCache.getFlags().size() == 0);
    }
}

