/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.lazy;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.lazy.LazyCacheAPITest")
public class LazyCacheAPITest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        Configuration c = this.getDefaultStandaloneConfig(true);
        c.setUseLazyDeserialization(true);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createLocalCacheManager(false);
        cm.defineConfiguration("lazy-cache-test", c);
        this.cache = cm.getCache("lazy-cache-test");
        return cm;
    }

    public void testReplace(Method m) {
        CustomPojo key = new CustomPojo(m.getName());
        this.cache.put((Object)key, (Object)"1");
        assert ("1".equals(this.cache.get((Object)new CustomPojo(m.getName()))));
        Object oldValue = this.cache.replace((Object)new CustomPojo(m.getName()), (Object)"2");
        assert ("1".equals(oldValue));
        assert ("2".equals(this.cache.get((Object)new CustomPojo(m.getName()))));
    }

    public void testReplaceWithOld(Method m) {
        CustomPojo key = new CustomPojo(m.getName());
        this.cache.put((Object)key, (Object)"1");
        assert ("1".equals(this.cache.get((Object)new CustomPojo(m.getName()))));
        assert (!this.cache.replace((Object)new CustomPojo(m.getName()), (Object)"99", (Object)"2"));
        assert (this.cache.replace((Object)new CustomPojo(m.getName()), (Object)"1", (Object)"2"));
        key = new CustomPojo(m.getName() + "-withCustomValue");
        CustomPojo v1 = new CustomPojo("value1");
        this.cache.put((Object)key, (Object)v1);
        assert (v1.equals(this.cache.get((Object)key)));
        CustomPojo v99 = new CustomPojo("value99");
        CustomPojo v2 = new CustomPojo("value2");
        assert (!this.cache.replace((Object)key, (Object)v99, (Object)v2));
        assert (this.cache.replace((Object)key, (Object)v1, (Object)v2));
    }

    public static class CustomPojo
    implements Serializable {
        static final Log log = LogFactory.getLog(CustomPojo.class);
        private String name;

        public CustomPojo(String name) {
            this.name = name;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                log.debug((Object)"null -> false");
                return false;
            }
            log.debug(obj.getClass());
            if (this.getClass() != obj.getClass()) {
                log.debug((Object)"class not same -> false");
                return false;
            }
            CustomPojo other = (CustomPojo)obj;
            return this.name.equals(other.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

