/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.lru.read_committed;

import org.infinispan.api.CacheAPITest;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.lru.read_committed.CacheAPIMVCCTest")
public class CacheAPIMVCCTest
extends CacheAPITest {
    @Override
    protected IsolationLevel getIsolationLevel() {
        return IsolationLevel.READ_COMMITTED;
    }

    @Override
    protected ConfigurationBuilder addEviction(ConfigurationBuilder cb) {
        cb.eviction().strategy(EvictionStrategy.LRU).maxEntries(1000).expiration().wakeUpInterval(60000L);
        return cb;
    }

    @Override
    public void testRollbackAfterClear() throws Exception {
        String key = "key";
        String value = "value";
        int size = 0;
        this.cache.put((Object)key, (Object)value);
        assert (this.cache.get((Object)key).equals(value));
        size = 1;
        assert (size == this.cache.size() && size == this.cache.keySet().size() && size == this.cache.values().size() && size == this.cache.entrySet().size());
        assert (this.cache.keySet().contains(key));
        assert (this.cache.values().contains(value));
        TestingUtil.getTransactionManager(this.cache).begin();
        this.cache.clear();
        assert (this.cache.get((Object)key) == null);
        size = 0;
        assert (size == this.cache.size());
        assert (size == this.cache.keySet().size());
        assert (size == this.cache.values().size());
        assert (size == this.cache.entrySet().size());
        TestingUtil.getTransactionManager(this.cache).rollback();
        assert (this.cache.get((Object)key).equals(value));
        size = 1;
        assert (size == this.cache.size() && size == this.cache.keySet().size() && size == this.cache.values().size() && size == this.cache.entrySet().size());
        assert (this.cache.keySet().contains(key));
        assert (this.cache.values().contains(value));
    }
}

