/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.lang.reflect.Method;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.atomic.AtomicMapLookup;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="atomic.AtomicHashMapPassivationTest")
public class AtomicHashMapPassivationTest
extends SingleCacheManagerTest {
    CacheStore store;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        Configuration c = this.getDefaultStandaloneConfig(true);
        c.setInvocationBatchingEnabled(true);
        c.setUseLazyDeserialization(true);
        CacheLoaderManagerConfig clmc = new CacheLoaderManagerConfig();
        clmc.setPassivation(Boolean.valueOf(true));
        clmc.addCacheLoaderConfig((CacheLoaderConfig)new DummyInMemoryCacheStore.Cfg());
        c.setCacheLoaderManagerConfig(clmc);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(c);
        this.cache = cm.getCache();
        this.store = TestingUtil.extractComponent(this.cache, CacheLoaderManager.class).getCacheStore();
        return cm;
    }

    public void testPassivateAndUpdate(Method m) throws Exception {
        String key = "k-" + m.getName();
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache);
        tm.begin();
        AtomicMap map = AtomicMapLookup.getAtomicMap((Cache)this.cache, (Object)key);
        assert (map.isEmpty());
        map.put((Object)"a", (Object)"b");
        assert (((String)map.get((Object)"a")).equals("b"));
        tm.commit();
        this.assertInCacheNotInStore(key);
        this.log.trace((Object)"About to evict...");
        this.cache.evict((Object)key);
        this.assertInStoreNotInCache(key);
        tm.begin();
        map = AtomicMapLookup.getAtomicMap((Cache)this.cache, (Object)key);
        map.put((Object)"a", (Object)"c");
        map.put((Object)"d", (Object)"e");
        tm.commit();
    }

    private void assertInCacheNotInStore(Object key) throws CacheLoaderException {
        InternalCacheEntry se = this.cache.getAdvancedCache().getDataContainer().get(key);
        this.testStoredEntry(se, key, "Cache");
        assert (!this.store.containsKey(key)) : "Key " + key + " should not be in store!";
    }

    private void testStoredEntry(InternalCacheEntry entry, Object key, String src) {
        assert (entry != null) : src + " entry for key " + key + " should NOT be null";
    }

    private void assertInStoreNotInCache(Object key) throws CacheLoaderException {
        InternalCacheEntry se = this.store.load(key);
        this.testStoredEntry(se, key, "Store");
        assert (!this.cache.getAdvancedCache().getDataContainer().containsKey(key)) : "Key " + key + " should not be in cache!";
    }
}

