/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.atomic.AtomicMapLookup;
import org.infinispan.atomic.FineGrainedAtomicMap;
import org.infinispan.config.Configuration;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.concurrent.TimeoutException;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="atomic.FineGrainedAtomicMapAPITest")
public class FineGrainedAtomicMapAPITest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration c = FineGrainedAtomicMapAPITest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC, true).fluent().transaction().transactionMode(TransactionMode.TRANSACTIONAL).lockingMode(LockingMode.PESSIMISTIC).locking().lockAcquisitionTimeout(Long.valueOf(100L)).build();
        this.createClusteredCaches(2, "atomic", c);
    }

    @Test(enabled=true)
    public void testMultipleTx() throws Exception {
        Cache cache1 = this.cache(0, "atomic");
        Cache cache2 = this.cache(1, "atomic");
        TransactionManager tm1 = TestingUtil.getTransactionManager(cache1);
        TransactionManager tm2 = TestingUtil.getTransactionManager(cache2);
        FineGrainedAtomicMap map1 = AtomicMapLookup.getFineGrainedAtomicMap(cache1, (Object)"testMultipleTx", (boolean)true);
        FineGrainedAtomicMap map2 = AtomicMapLookup.getFineGrainedAtomicMap(cache2, (Object)"testMultipleTx", (boolean)false);
        assert (map2.size() == 0 && map1.size() == 0);
        tm1.begin();
        map1.put((Object)"k1", (Object)"initial");
        tm1.commit();
        assert (map2.size() == 1 && map1.size() == 1);
        tm1.begin();
        map1.put((Object)"k1", (Object)"v1");
        map1.put((Object)"k2", (Object)"v2");
        map1.put((Object)"k3", (Object)"v3");
        tm1.commit();
        assert (map1.size() == 3);
        assert (map2.size() == 3);
        tm1.begin();
        map1.put((Object)"k4", (Object)"v4");
        map1.put((Object)"k5", (Object)"v5");
        map1.put((Object)"k6", (Object)"v6");
        tm1.commit();
        assert (((String)map2.get((Object)"k1")).equals("v1"));
        assert (((String)map2.get((Object)"k2")).equals("v2"));
        assert (((String)map2.get((Object)"k3")).equals("v3"));
        assert (((String)map2.get((Object)"k4")).equals("v4"));
        assert (((String)map2.get((Object)"k5")).equals("v5"));
        assert (((String)map2.get((Object)"k6")).equals("v6"));
        assert (((String)map1.get((Object)"k1")).equals("v1"));
        assert (((String)map1.get((Object)"k2")).equals("v2"));
        assert (((String)map1.get((Object)"k3")).equals("v3"));
        assert (((String)map1.get((Object)"k4")).equals("v4"));
        assert (((String)map1.get((Object)"k5")).equals("v5"));
        assert (((String)map1.get((Object)"k6")).equals("v6"));
    }

    @Test(enabled=true)
    public void testSizeOnCache() throws Exception {
        Cache cache1 = this.cache(0, "atomic");
        assert (cache1.size() == 0);
        cache1.put((Object)"Hi", (Object)"Someone");
        assert (cache1.size() == 1);
        this.tm(0, "atomic").begin();
        assert (cache1.size() == 1);
        cache1.put((Object)"Need", (Object)"Read Consistency");
        assert (cache1.size() == 2);
        this.tm(0, "atomic").commit();
        assert (cache1.size() == 2);
        this.tm(0, "atomic").begin();
        assert (cache1.size() == 2);
        cache1.put((Object)"Need Also", (Object)"Speed");
        assert (cache1.size() == 3);
        this.tm(0, "atomic").rollback();
        assert (cache1.size() == 2);
        FineGrainedAtomicMap atomicMap = AtomicMapLookup.getFineGrainedAtomicMap(cache1, (Object)"testSizeOnCache", (boolean)true);
        assert (cache1.size() == 3);
        atomicMap.put((Object)"mm", (Object)"nn");
        assert (cache1.size() == 3);
        this.tm(0, "atomic").begin();
        assert (cache1.size() == 3);
        atomicMap = AtomicMapLookup.getFineGrainedAtomicMap(cache1, (Object)"testSizeOnCache-second", (boolean)true);
        assert (cache1.size() == 4);
        atomicMap.put((Object)"mm", (Object)"nn");
        assert (cache1.size() == 4) : "Cache size is actually " + cache1.size();
        this.tm(0, "atomic").commit();
        assert (cache1.size() == 4);
        this.tm(0, "atomic").begin();
        assert (cache1.size() == 4);
        atomicMap = AtomicMapLookup.getFineGrainedAtomicMap(cache1, (Object)"testSizeOnCache-third", (boolean)true);
        assert (cache1.size() == 5);
        atomicMap.put((Object)"mm", (Object)"nn");
        assert (cache1.size() == 5) : "Cache size is actually " + cache1.size();
        atomicMap.put((Object)"ooo", (Object)"weird!");
        assert (cache1.size() == 5) : "Cache size is actually " + cache1.size();
        atomicMap = AtomicMapLookup.getFineGrainedAtomicMap(cache1, (Object)"testSizeOnCache-onemore", (boolean)true);
        assert (cache1.size() == 6) : "Cache size is actually " + cache1.size();
        atomicMap.put((Object)"even less?", (Object)"weird!");
        assert (cache1.size() == 6) : "Cache size is actually " + cache1.size();
        this.tm(0, "atomic").rollback();
        assert (cache1.size() == 4);
    }

    @Test(enabled=true)
    public void testConcurrentReadsOnExistingMap() throws Exception {
        final Cache cache1 = this.cache(0, "atomic");
        assert (cache1.size() == 0);
        FineGrainedAtomicMap map = AtomicMapLookup.getFineGrainedAtomicMap(cache1, (Object)"testConcurrentReadsOnExistingMap", (boolean)true);
        map.put((Object)"the-1", (Object)"my preciousss");
        this.tm(0, "atomic").begin();
        assert ("my preciousss".equals(map.get((Object)"the-1")));
        final AtomicBoolean allok = new AtomicBoolean(false);
        map.put((Object)"the-2", (Object)"a minor");
        this.fork(new Runnable(){

            @Override
            public void run() {
                try {
                    FineGrainedAtomicMapAPITest.this.tm(0, "atomic").begin();
                    FineGrainedAtomicMap map = AtomicMapLookup.getFineGrainedAtomicMap((Cache)cache1, (Object)"testConcurrentReadsOnExistingMap", (boolean)true);
                    assert ("my preciousss".equals(map.get((Object)"the-1")));
                    assert (!map.containsKey((Object)"the-2"));
                    FineGrainedAtomicMapAPITest.this.tm(0, "atomic").commit();
                    allok.set(true);
                }
                catch (Exception e) {
                    FineGrainedAtomicMapAPITest.this.log.error((Object)"Unexpected error performing transaction", (Throwable)e);
                }
            }
        }, true);
        this.tm(0, "atomic").commit();
        assert (allok.get());
    }

    @Test(enabled=true)
    public void testConcurrentWritesOnExistingMap() throws Exception {
        final Cache cache1 = this.cache(0, "atomic");
        assert (cache1.size() == 0);
        FineGrainedAtomicMap map = AtomicMapLookup.getFineGrainedAtomicMap(cache1, (Object)"testConcurrentReadsOnExistingMap", (boolean)true);
        map.put((Object)"the-1", (Object)"my preciousss");
        this.tm(0, "atomic").begin();
        assert ("my preciousss".equals(map.get((Object)"the-1")));
        final AtomicBoolean allok = new AtomicBoolean(false);
        map.put((Object)"the-2", (Object)"a minor");
        this.fork(new Runnable(){

            @Override
            public void run() {
                try {
                    FineGrainedAtomicMapAPITest.this.tm(0, "atomic").begin();
                    FineGrainedAtomicMap map = AtomicMapLookup.getFineGrainedAtomicMap((Cache)cache1, (Object)"testConcurrentReadsOnExistingMap", (boolean)true);
                    assert ("my preciousss".equals(map.get((Object)"the-1")));
                    assert (!map.containsKey((Object)"the-2"));
                    map.put((Object)"the-2", (Object)"a minor-different");
                    FineGrainedAtomicMapAPITest.this.tm(0, "atomic").commit();
                }
                catch (TimeoutException e) {
                    allok.set(true);
                }
                catch (Exception e) {
                    FineGrainedAtomicMapAPITest.this.log.error((Object)"Unexpected error performing transaction", (Throwable)e);
                }
            }
        }, true);
        this.tm(0, "atomic").commit();
        assert (allok.get());
    }

    @Test(enabled=true)
    public void testConcurrentWritesAndIteration() throws Exception {
        final Cache cache1 = this.cache(0, "atomic");
        assert (cache1.size() == 0);
        FineGrainedAtomicMap map = AtomicMapLookup.getFineGrainedAtomicMap(cache1, (Object)"testConcurrentWritesAndIteration", (boolean)true);
        assert (map.size() == 0);
        final AtomicBoolean allOk = new AtomicBoolean(true);
        final CountDownLatch latch = new CountDownLatch(1);
        Thread t1 = this.fork(new Runnable(){

            @Override
            public void run() {
                try {
                    FineGrainedAtomicMap map = AtomicMapLookup.getFineGrainedAtomicMap((Cache)cache1, (Object)"testConcurrentWritesAndIteration", (boolean)true);
                    latch.await();
                    for (int i = 0; i < 500; ++i) {
                        map.put((Object)("key-" + i), (Object)("value-" + i));
                    }
                }
                catch (Exception e) {
                    FineGrainedAtomicMapAPITest.this.log.error((Object)"Unexpected error performing transaction", (Throwable)e);
                }
            }
        }, false);
        Thread t2 = this.fork(new Runnable(){

            @Override
            public void run() {
                FineGrainedAtomicMap map = AtomicMapLookup.getFineGrainedAtomicMap((Cache)cache1, (Object)"testConcurrentWritesAndIteration", (boolean)true);
                try {
                    latch.await();
                    for (int i = 0; i < 500; ++i) {
                        map.keySet();
                    }
                }
                catch (Exception e) {
                    allOk.set(false);
                    FineGrainedAtomicMapAPITest.this.log.error((Object)"Unexpected error performing transaction", (Throwable)e);
                }
            }
        }, false);
        latch.countDown();
        t1.join();
        t2.join();
        assert (allOk.get()) : "iteration raised an exception";
    }

    @Test(enabled=true)
    public void testRollback() throws Exception {
        Cache cache1 = this.cache(0, "atomic");
        Cache cache2 = this.cache(1, "atomic");
        FineGrainedAtomicMap map1 = AtomicMapLookup.getFineGrainedAtomicMap(cache1, (Object)"testRollback", (boolean)true);
        this.tm(0, "atomic").begin();
        map1.put((Object)"k1", (Object)"v");
        map1.put((Object)"k2", (Object)"v2");
        this.tm(0, "atomic").rollback();
        FineGrainedAtomicMap instance = AtomicMapLookup.getFineGrainedAtomicMap(cache2, (Object)"testRollback", (boolean)true);
        assert (!instance.containsKey((Object)"k1"));
        assert (!map1.containsKey((Object)"k1"));
    }

    @Test(enabled=true, expectedExceptions={IllegalArgumentException.class})
    public void testFineGrainedMapAfterSimpleMap() throws Exception {
        Cache cache1 = this.cache(0, "atomic");
        AtomicMap map = AtomicMapLookup.getAtomicMap(cache1, (Object)"testReplicationRemoveCommit");
        FineGrainedAtomicMap map2 = AtomicMapLookup.getFineGrainedAtomicMap(cache1, (Object)"testReplicationRemoveCommit");
    }

    @Test(enabled=true)
    public void testRollbackAndThenCommit() throws Exception {
        Cache cache1 = this.cache(0, "atomic");
        Cache cache2 = this.cache(1, "atomic");
        FineGrainedAtomicMap map1 = AtomicMapLookup.getFineGrainedAtomicMap(cache1, (Object)"testRollbackAndThenCommit", (boolean)true);
        this.tm(0, "atomic").begin();
        map1.put((Object)"k1", (Object)"v");
        map1.put((Object)"k2", (Object)"v2");
        this.tm(0, "atomic").rollback();
        FineGrainedAtomicMap map2 = AtomicMapLookup.getFineGrainedAtomicMap(cache2, (Object)"testRollbackAndThenCommit", (boolean)true);
        assert (!map2.containsKey((Object)"k1"));
        assert (!map1.containsKey((Object)"k1"));
        this.tm(0, "atomic").begin();
        map1.put((Object)"k3", (Object)"v3");
        map1.put((Object)"k4", (Object)"v4");
        this.tm(0, "atomic").commit();
        assert (map1.size() == 2 && map2.size() == 2);
    }

    @Test(enabled=true)
    public void testCreateMapInTx() throws Exception {
        Cache cache1 = this.cache(0, "atomic");
        Cache cache2 = this.cache(1, "atomic");
        this.tm(0, "atomic").begin();
        FineGrainedAtomicMap map1 = AtomicMapLookup.getFineGrainedAtomicMap(cache1, (Object)"testCreateMapInTx", (boolean)true);
        map1.put((Object)"k1", (Object)"v1");
        this.tm(0, "atomic").commit();
        assert (map1.size() == 1);
        assert (((String)map1.get((Object)"k1")).equals("v1"));
        FineGrainedAtomicMap map2 = AtomicMapLookup.getFineGrainedAtomicMap(cache2, (Object)"testCreateMapInTx", (boolean)true);
        assert (map2.size() == 1);
        assert (((String)map2.get((Object)"k1")).equals("v1"));
    }

    @Test(enabled=true)
    public void testNoTx() throws Exception {
        Cache cache1 = this.cache(0, "atomic");
        Cache cache2 = this.cache(1, "atomic");
        FineGrainedAtomicMap map = AtomicMapLookup.getFineGrainedAtomicMap(cache1, (Object)"testNoTx", (boolean)true);
        map.put((Object)"existing", (Object)"existing");
        map.put((Object)"blah", (Object)"blah");
        assert (map.size() == 2);
        assert (((String)map.get((Object)"blah")).equals("blah"));
        assert (map.containsKey((Object)"existing"));
    }

    @Test(enabled=true)
    public void testReadUncommittedValues() throws Exception {
        Cache cache1 = this.cache(0, "atomic");
        Cache cache2 = this.cache(1, "atomic");
        FineGrainedAtomicMap map = AtomicMapLookup.getFineGrainedAtomicMap(cache1, (Object)"testReadUncommittedValues");
        TestingUtil.getTransactionManager(cache1).begin();
        map.put((Object)"key one", (Object)"value one");
        map.put((Object)"blah", (Object)"blah");
        assert ("value one".equals(map.get((Object)"key one")));
        assert (map.size() == 2);
        assert (map.keySet().size() == 2);
        Set keySet = map.keySet();
        for (String k : keySet) {
            assert (k.equals("key one") || k.equals("blah"));
        }
        Collection values = map.values();
        for (String v : values) {
            assert (v.equals("value one") || v.equals("blah"));
        }
        assert (map.containsKey((Object)"key one"));
        assert (map.values().size() == 2);
        assert (!map.isEmpty());
        Set entrySet = map.entrySet();
        for (Map.Entry entry : entrySet) {
            if (((String)entry.getKey()).equals("key one")) assert (((String)entry.getValue()).equals("value one"));
            if (((String)entry.getKey()).equals("blah")) assert (((String)entry.getValue()).equals("blah"));
        }
        FineGrainedAtomicMap sameAsMap = AtomicMapLookup.getFineGrainedAtomicMap(cache1, (Object)"testReadUncommittedValues");
        assert ("value one".equals(sameAsMap.get((Object)"key one")));
        TestingUtil.getTransactionManager(cache1).commit();
        assert (map.size() == 2);
        assert (((String)map.get((Object)"blah")).equals("blah"));
    }

    @Test(enabled=true)
    public void testCommitReadUncommittedValues() throws Exception {
        Cache cache1 = this.cache(0, "atomic");
        Cache cache2 = this.cache(1, "atomic");
        FineGrainedAtomicMap map = AtomicMapLookup.getFineGrainedAtomicMap(cache1, (Object)"testCommitReadUncommittedValues");
        TestingUtil.getTransactionManager(cache1).begin();
        map.put((Object)"existing", (Object)"existing");
        map.put((Object)"hey", (Object)"blah");
        TestingUtil.getTransactionManager(cache1).commit();
        TestingUtil.getTransactionManager(cache1).begin();
        map.put((Object)"key one", (Object)"value one");
        map.put((Object)"blah", (Object)"toronto");
        assert ("value one".equals(map.get((Object)"key one")));
        assert (map.size() == 4);
        assert (map.keySet().size() == 4);
        Set keySet = map.keySet();
        for (String k : keySet) {
            assert (k.equals("key one") || k.equals("blah") || k.equals("existing") || k.equals("hey"));
        }
        Collection values = map.values();
        for (String v : values) {
            assert (v.equals("value one") || v.equals("blah") || v.equals("existing") || v.equals("toronto"));
        }
        assert (map.containsKey((Object)"key one"));
        assert (map.values().size() == 4);
        assert (!map.isEmpty());
        Set entrySet = map.entrySet();
        for (Map.Entry entry : entrySet) {
            if (((String)entry.getKey()).equals("key one")) assert (((String)entry.getValue()).equals("value one"));
            if (((String)entry.getKey()).equals("blah")) assert (((String)entry.getValue()).equals("toronto"));
            if (((String)entry.getKey()).equals("existing")) assert (((String)entry.getValue()).equals("existing"));
            if (((String)entry.getKey()).equals("hey")) assert (((String)entry.getValue()).equals("blah"));
        }
        FineGrainedAtomicMap sameAsMap = AtomicMapLookup.getFineGrainedAtomicMap(cache1, (Object)"testCommitReadUncommittedValues");
        assert ("value one".equals(sameAsMap.get((Object)"key one")));
        TestingUtil.getTransactionManager(cache1).commit();
        assert (map.size() == 4);
        assert (((String)map.get((Object)"blah")).equals("toronto"));
    }

    @Test(enabled=true)
    public void testConcurrentTx() throws Exception {
        Cache cache1 = this.cache(0, "atomic");
        Cache cache2 = this.cache(1, "atomic");
        final TransactionManager tm1 = TestingUtil.getTransactionManager(cache1);
        final TransactionManager tm2 = TestingUtil.getTransactionManager(cache2);
        final FineGrainedAtomicMap map1 = AtomicMapLookup.getFineGrainedAtomicMap(cache1, (Object)"testConcurrentTx", (boolean)true);
        tm1.begin();
        map1.put((Object)"k1", (Object)"initial");
        tm1.commit();
        final FineGrainedAtomicMap map2 = AtomicMapLookup.getFineGrainedAtomicMap(cache2, (Object)"testConcurrentTx", (boolean)false);
        assert (map2.size() == 1 && map1.size() == 1);
        Thread t1 = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    tm1.begin();
                    map1.put((Object)"k1", (Object)"tx1Value");
                    tm1.commit();
                }
                catch (Exception e) {
                    FineGrainedAtomicMapAPITest.this.log.error((Object)e);
                }
            }
        });
        t1.start();
        Thread t2 = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    tm2.begin();
                    map2.put((Object)"k2", (Object)"tx2Value");
                    tm2.commit();
                }
                catch (Exception e) {
                    FineGrainedAtomicMapAPITest.this.log.error((Object)e);
                }
            }
        });
        t2.start();
        t2.join();
        t1.join();
        assert (((String)map2.get((Object)"k2")).equals("tx2Value"));
        assert (((String)map2.get((Object)"k1")).equals("tx1Value"));
        assert (((String)map1.get((Object)"k2")).equals("tx2Value"));
        assert (((String)map1.get((Object)"k1")).equals("tx1Value"));
    }

    @Test(enabled=true)
    public void testReplicationPutCommit() throws Exception {
        Cache cache1 = this.cache(0, "atomic");
        Cache cache2 = this.cache(1, "atomic");
        FineGrainedAtomicMap map = AtomicMapLookup.getFineGrainedAtomicMap(cache1, (Object)"testReplicationPutCommit");
        TestingUtil.getTransactionManager(cache1).begin();
        map.put((Object)"existing", (Object)"existing");
        map.put((Object)"blah", (Object)"blah");
        TestingUtil.getTransactionManager(cache1).commit();
        assert (map.size() == 2);
        assert (((String)map.get((Object)"blah")).equals("blah"));
        assert (map.containsKey((Object)"existing"));
        FineGrainedAtomicMap other = AtomicMapLookup.getFineGrainedAtomicMap(cache2, (Object)"testReplicationPutCommit", (boolean)false);
        assert (other.size() == 2) : " no, other size is " + other.size();
        assert (other.get((Object)"blah").equals("blah"));
        assert (other.containsKey((Object)"blah"));
        TestingUtil.getTransactionManager(cache2).begin();
        other.put((Object)"existing", (Object)"not existing");
        other.put((Object)"not existing", (Object)"peace on Earth");
        TestingUtil.getTransactionManager(cache2).commit();
        assert (map.size() == 3);
        assert (((String)map.get((Object)"blah")).equals("blah"));
        assert (((String)map.get((Object)"existing")).equals("not existing"));
        assert (((String)map.get((Object)"not existing")).equals("peace on Earth"));
        assert (other.size() == 3);
        assert (other.get((Object)"blah").equals("blah"));
        assert (other.get((Object)"existing").equals("not existing"));
        assert (other.get((Object)"not existing").equals("peace on Earth"));
    }

    @Test(enabled=true)
    public void testReplicationRemoveCommit() throws Exception {
        Cache cache1 = this.cache(0, "atomic");
        Cache cache2 = this.cache(1, "atomic");
        FineGrainedAtomicMap map = AtomicMapLookup.getFineGrainedAtomicMap(cache1, (Object)"testReplicationRemoveCommit");
        TestingUtil.getTransactionManager(cache1).begin();
        map.put((Object)"existing", (Object)"existing");
        map.put((Object)"blah", (Object)"blah");
        TestingUtil.getTransactionManager(cache1).commit();
        assert (map.size() == 2);
        assert (((String)map.get((Object)"blah")).equals("blah"));
        assert (map.containsKey((Object)"existing"));
        FineGrainedAtomicMap other = AtomicMapLookup.getFineGrainedAtomicMap(cache2, (Object)"testReplicationRemoveCommit", (boolean)false);
        assert (other.size() == 2) : " no, other size is " + other.size();
        assert (other.get((Object)"blah").equals("blah"));
        assert (other.containsKey((Object)"blah"));
        TestingUtil.getTransactionManager(cache2).begin();
        String removed = (String)map.remove((Object)"existing");
        assert (removed.equals("existing"));
        TestingUtil.getTransactionManager(cache2).commit();
        assert (map.size() == 1);
        assert (((String)map.get((Object)"blah")).equals("blah"));
        assert (other.size() == 1);
        assert (other.get((Object)"blah").equals("blah"));
    }

    @Test(enabled=true)
    public void testReplicationPutAndClearCommit() throws Exception {
        Cache cache1 = this.cache(0, "atomic");
        Cache cache2 = this.cache(1, "atomic");
        FineGrainedAtomicMap map = AtomicMapLookup.getFineGrainedAtomicMap(cache1, (Object)"map");
        FineGrainedAtomicMap map2 = AtomicMapLookup.getFineGrainedAtomicMap(cache2, (Object)"map", (boolean)false);
        TestingUtil.getTransactionManager(cache1).begin();
        map.put((Object)"existing", (Object)"existing");
        map.put((Object)"blah", (Object)"blah");
        map.size();
        TestingUtil.getTransactionManager(cache1).commit();
        assert (map.size() == 2);
        assert (map2.size() == 2);
        TestingUtil.getTransactionManager(cache2).begin();
        map2.clear();
        TestingUtil.getTransactionManager(cache2).commit();
        assert (map.size() == 0);
        assert (map2.size() == 0);
    }
}

