/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration;

import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.manager.DefaultCacheManager;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ConfigurationOverrideTest {
    public void testConfigurationOverride() {
        org.infinispan.configuration.cache.Configuration defaultConfiguration = new ConfigurationBuilder().eviction().maxEntries(200).strategy(EvictionStrategy.LIRS).build();
        org.infinispan.configuration.cache.Configuration cacheConfiguration = new ConfigurationBuilder().read(defaultConfiguration).build();
        DefaultCacheManager embeddedCacheManager = new DefaultCacheManager(defaultConfiguration);
        embeddedCacheManager.defineConfiguration("my-cache", cacheConfiguration);
        Cache cache = embeddedCacheManager.getCache("my-cache");
        Assert.assertEquals((int)cache.getCacheConfiguration().eviction().maxEntries(), (int)200);
        Assert.assertEquals((Object)cache.getCacheConfiguration().eviction().strategy(), (Object)EvictionStrategy.LIRS);
    }

    public void testOldConfigurationOverride() {
        Configuration defaultConfiguration = new Configuration().fluent().eviction().maxEntries(Integer.valueOf(200)).strategy(EvictionStrategy.LIRS).build();
        Configuration cacheConfiguration = new Configuration().fluent().build();
        DefaultCacheManager embeddedCacheManager = new DefaultCacheManager(defaultConfiguration);
        embeddedCacheManager.defineConfiguration("my-cache", cacheConfiguration);
        Cache cache = embeddedCacheManager.getCache("my-cache");
        Assert.assertEquals((int)cache.getConfiguration().getEvictionMaxEntries(), (int)200);
        Assert.assertEquals((Object)cache.getConfiguration().getEvictionStrategy(), (Object)EvictionStrategy.LIRS);
    }

    public void testSimpleDistributedClusterModeDefault() {
        org.infinispan.configuration.cache.Configuration config = new ConfigurationBuilder().clustering().cacheMode(CacheMode.DIST_SYNC).hash().numOwners(3).numVirtualNodes(51).build();
        GlobalConfiguration globalConfig = GlobalConfigurationBuilder.defaultClusteredBuilder().build();
        DefaultCacheManager cm = new DefaultCacheManager(globalConfig, config);
        Cache cache = cm.getCache("my-cache");
        Assert.assertEquals((Object)cache.getCacheConfiguration().clustering().cacheMode(), (Object)CacheMode.DIST_SYNC);
        Assert.assertEquals((int)cache.getCacheConfiguration().clustering().hash().numOwners(), (int)3);
        Assert.assertEquals((int)cache.getCacheConfiguration().clustering().hash().numVirtualNodes(), (int)51);
    }

    public void testSimpleDistributedClusterModeNamedCache() {
        String cacheName = "my-cache";
        org.infinispan.configuration.cache.Configuration config = new ConfigurationBuilder().clustering().cacheMode(CacheMode.DIST_SYNC).hash().numOwners(3).numVirtualNodes(51).build();
        GlobalConfiguration globalConfig = GlobalConfigurationBuilder.defaultClusteredBuilder().build();
        DefaultCacheManager cm = new DefaultCacheManager(globalConfig);
        cm.defineConfiguration(cacheName, config);
        Cache cache = cm.getCache(cacheName);
        Assert.assertEquals((Object)cache.getCacheConfiguration().clustering().cacheMode(), (Object)CacheMode.DIST_SYNC);
        Assert.assertEquals((int)cache.getCacheConfiguration().clustering().hash().numOwners(), (int)3);
        Assert.assertEquals((int)cache.getCacheConfiguration().clustering().hash().numVirtualNodes(), (int)51);
    }
}

