/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration;

import java.net.URL;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.infinispan.Cache;
import org.infinispan.config.ConfigurationException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.LegacyConfigurationAdaptor;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.FileLookup;
import org.infinispan.util.FileLookupFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="config.ConfigurationUnitTest")
public class ConfigurationUnitTest {
    @Test
    public void testBuild() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.build();
    }

    @Test
    public void testCreateCache() throws Exception {
        TestingUtil.withCacheManager(new CacheManagerCallable((EmbeddedCacheManager)new DefaultCacheManager(new ConfigurationBuilder().build())));
    }

    @Test
    public void testAdapt() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        LegacyConfigurationAdaptor.adapt((Configuration)cb.build());
    }

    @Test
    public void testEvictionMaxEntries() {
        Configuration configuration = new ConfigurationBuilder().eviction().maxEntries(20).build();
        org.infinispan.config.Configuration legacy = LegacyConfigurationAdaptor.adapt((Configuration)configuration);
        Assert.assertEquals((int)legacy.getEvictionMaxEntries(), (int)20);
    }

    @Test
    public void testDistSyncAutoCommit() {
        Configuration configuration = new ConfigurationBuilder().clustering().cacheMode(CacheMode.DIST_SYNC).transaction().autoCommit(true).build();
        org.infinispan.config.Configuration legacy = LegacyConfigurationAdaptor.adapt((Configuration)configuration);
        Assert.assertTrue((boolean)legacy.isTransactionAutoCommit());
        Assert.assertEquals((String)legacy.getCacheMode().name(), (String)CacheMode.DIST_SYNC.name());
    }

    @Test
    public void testDummyTMGetCache() throws Exception {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.transaction().use1PcForAutoCommitTransactions(true).transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup());
        TestingUtil.withCacheManager(new CacheManagerCallable((EmbeddedCacheManager)new DefaultCacheManager(cb.build())){

            @Override
            public void call() throws Exception {
                this.cm.getCache();
            }
        });
    }

    @Test
    public void testGetCache() throws Exception {
        TestingUtil.withCacheManager(new CacheManagerCallable((EmbeddedCacheManager)new DefaultCacheManager(new ConfigurationBuilder().build())){

            @Override
            public void call() throws Exception {
                this.cm.getCache();
            }
        });
    }

    @Test
    public void testDefineNamedCache() throws Exception {
        TestingUtil.withCacheManager(new CacheManagerCallable((EmbeddedCacheManager)new DefaultCacheManager(new ConfigurationBuilder().build())){

            @Override
            public void call() throws Exception {
                this.cm.defineConfiguration("foo", new ConfigurationBuilder().build());
            }
        });
    }

    @Test
    public void testGetAndPut() throws Exception {
        TestingUtil.withCacheManager(new CacheManagerCallable((EmbeddedCacheManager)new DefaultCacheManager(new ConfigurationBuilder().build())){

            @Override
            public void call() throws Exception {
                Cache cache = this.cm.getCache();
                cache.put((Object)"Foo", (Object)"2");
                cache.put((Object)"Bar", (Object)"4");
                Assert.assertEquals((String)((String)cache.get((Object)"Foo")), (String)"2");
                Assert.assertEquals((String)((String)cache.get((Object)"Bar")), (String)"4");
            }
        });
    }

    @Test
    public void testReplAsyncWithQueue() {
        Configuration configuration = new ConfigurationBuilder().clustering().cacheMode(CacheMode.REPL_ASYNC).async().useReplQueue(true).replQueueInterval(1222L).build();
        org.infinispan.config.Configuration legacy = LegacyConfigurationAdaptor.adapt((Configuration)configuration);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testInvocationBatchingAndNonTransactional() throws Exception {
        Configuration c = new ConfigurationBuilder().transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL).invocationBatching().enable().build();
        TestingUtil.withCacheManager(new CacheManagerCallable((EmbeddedCacheManager)new DefaultCacheManager(c)));
    }

    @Test
    public void testConsistentHash() {
        Configuration config = LegacyConfigurationAdaptor.adapt((org.infinispan.config.Configuration)new org.infinispan.config.Configuration());
        Assert.assertNull((Object)config.clustering().hash().consistentHash());
    }

    @Test
    public void testDisableL1() throws Exception {
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createClusteredCacheManager(new ConfigurationBuilder(), new TransportFlags())){

            @Override
            public void call() throws Exception {
                ConfigurationBuilder cb = new ConfigurationBuilder();
                cb.clustering().cacheMode(CacheMode.DIST_SYNC).l1().disable().disableOnRehash();
                this.cm.defineConfiguration("testConfigCache", cb.build());
                Cache cache = this.cm.getCache("testConfigCache");
                assert (!cache.getCacheConfiguration().clustering().l1().enabled());
                assert (!cache.getCacheConfiguration().clustering().l1().onRehash());
            }
        });
    }

    @Test
    public void testClearCacheLoaders() {
        Configuration c = new ConfigurationBuilder().loaders().addCacheLoader().loaders().clearCacheLoaders().build();
        Assert.assertEquals((int)c.loaders().cacheLoaders().size(), (int)0);
    }

    @Test(expectedExceptions={ConfigurationException.class})
    public void testClusterNameNull() {
        GlobalConfigurationBuilder gc = new GlobalConfigurationBuilder();
        gc.transport().clusterName(null).build();
    }

    @Test
    public void testSchema() throws Exception {
        FileLookup lookup = FileLookupFactory.newInstance();
        URL schemaFile = lookup.lookupFileLocation("schema/infinispan-config-5.1.xsd", Thread.currentThread().getContextClassLoader());
        StreamSource xmlFile = new StreamSource(lookup.lookupFile("configs/all.xml", Thread.currentThread().getContextClassLoader()));
        SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaFile).newValidator().validate(xmlFile);
    }

    public void testEvictionWithoutStrategy() throws Exception {
        Configuration c = new ConfigurationBuilder().eviction().maxEntries(76767).build();
        TestingUtil.withCacheManager(new CacheManagerCallable((EmbeddedCacheManager)new DefaultCacheManager(c)){

            @Override
            public void call() throws Exception {
                Configuration cfg = this.cm.getCache().getCacheConfiguration();
                assert (cfg.eviction().maxEntries() == 76767);
                assert (cfg.eviction().strategy() != EvictionStrategy.NONE);
            }
        });
    }
}

