/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context;

import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.config.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="context.InvocationContextTest")
public class InvocationContextTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(InvocationContextTest.class);

    public InvocationContextTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration cfg = TestCacheManagerFactory.getDefaultConfiguration(true);
        cfg.setSyncCommitPhase(true);
        cfg.setSyncRollbackPhase(true);
        cfg.fluent().transaction().lockingMode(LockingMode.PESSIMISTIC);
        this.createClusteredCaches(1, "timestamps", cfg);
    }

    public void testMishavingListenerResumesContext() {
        block2: {
            Cache cache = this.cache(0, "timestamps");
            cache.addListener((Object)new CacheListener());
            try {
                cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"k", (Object)"v");
            }
            catch (CacheException ce) {
                if ($assertionsDisabled || ce.getCause() instanceof RuntimeException) break block2;
                throw new AssertionError();
            }
        }
    }

    public void testThreadInterruptedDuringLocking() throws Throwable {
        final Cache cache = this.cache(0, "timestamps");
        cache.put((Object)"k", (Object)"v");
        TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
        tm.begin();
        cache.put((Object)"k", (Object)"v2");
        Transaction tx = tm.suspend();
        final LinkedList throwables = new LinkedList();
        Thread th = new Thread(){

            @Override
            public void run() {
                try {
                    cache.put((Object)"k", (Object)"v3");
                }
                catch (Throwable th) {
                    throwables.add(th);
                }
            }
        };
        th.start();
        th.interrupt();
        th.join();
        tm.resume(tx);
        tm.rollback();
        assert (throwables.size() == 1);
        for (Throwable thr : throwables) {
            thr.printStackTrace();
        }
        assert (throwables.get(0) instanceof CacheException);
        assert (((Throwable)throwables.get(0)).getCause() instanceof InterruptedException);
    }

    public void testThreadInterruptedAfterLocking() throws Throwable {
        final Cache cache = this.cache(0, "timestamps");
        cache.put((Object)"k", (Object)"v");
        CountDownLatch willTimeoutLatch = new CountDownLatch(1);
        CountDownLatch lockAquiredSignal = new CountDownLatch(1);
        DelayingListener dl = new DelayingListener(lockAquiredSignal, willTimeoutLatch);
        cache.addListener((Object)dl);
        final LinkedList throwables = new LinkedList();
        Thread th = new Thread(){

            @Override
            public void run() {
                try {
                    cache.put((Object)"k", (Object)"v3");
                }
                catch (Throwable th) {
                    throwables.add(th);
                }
            }
        };
        th.start();
        lockAquiredSignal.await();
        th.interrupt();
        th.join();
        assert (throwables.size() == 1);
        for (Throwable thr : throwables) {
            thr.printStackTrace();
        }
        assert (throwables.get(0) instanceof CacheException);
    }

    @Listener
    public static class CacheListener {
        @CacheEntryModified
        public void entryModified(CacheEntryModifiedEvent event) {
            if (!event.isPre()) {
                log.debugf("Entry modified: %s, let's throw an exception!!", (Object)event);
                throw new RuntimeException("Testing exception handling");
            }
        }
    }

    @Listener
    public static class DelayingListener {
        CountDownLatch lockAcquiredLatch;
        CountDownLatch waitLatch;

        public DelayingListener(CountDownLatch lockAcquiredLatch, CountDownLatch waitLatch) {
            this.lockAcquiredLatch = lockAcquiredLatch;
            this.waitLatch = waitLatch;
        }

        @CacheEntryModified
        public void entryModified(CacheEntryModifiedEvent event) {
            if (!event.isPre()) {
                this.lockAcquiredLatch.countDown();
                try {
                    this.waitLatch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

