/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.distribution.DistSyncTxFuncTest;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.ReplListener;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.DistAsyncTxFuncTest")
public class DistAsyncTxFuncTest
extends DistSyncTxFuncTest {
    ReplListener r1;
    ReplListener r2;
    ReplListener r3;
    ReplListener r4;
    ReplListener[] r;
    Map<Cache<?, ?>, ReplListener> listenerLookup;
    List<Address> listenerCaches;

    public DistAsyncTxFuncTest() {
        this.sync = false;
        this.tx = true;
        this.testRetVals = true;
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        super.createCacheManagers();
        this.r1 = new ReplListener(this.c1, true, true);
        this.r2 = new ReplListener(this.c2, true, true);
        this.r3 = new ReplListener(this.c3, true, true);
        this.r4 = new ReplListener(this.c4, true, true);
        this.r = new ReplListener[]{this.r1, this.r2, this.r3, this.r4};
        this.listenerLookup = new HashMap();
        this.listenerCaches = new ArrayList<Address>();
        for (ReplListener rl : this.r) {
            this.listenerCaches.add(this.addressOf(rl.getCache()));
            this.listenerLookup.put(rl.getCache(), rl);
        }
    }

    @Override
    protected void asyncWait(Object key, Class<? extends VisitableCommand> command, Cache<?, ?> ... cachesOnWhichKeyShouldInval) {
        if (cachesOnWhichKeyShouldInval == null) {
            cachesOnWhichKeyShouldInval = new Cache[]{};
        }
        ArrayList cachesOnWhichKeyShouldInvalList = new ArrayList(Arrays.asList(cachesOnWhichKeyShouldInval));
        if (key == null) {
            for (ReplListener rl : this.r) {
                rl.expect(command);
            }
            for (ReplListener rl : this.r) {
                rl.waitForRpc();
            }
        } else {
            for (Cache<Object, String> c : this.getOwners(key)) {
                this.log.info((Object)("Analysing cache " + this.addressOf(c) + ".  Listeners are avbl for caches " + this.listenerCaches));
                if (cachesOnWhichKeyShouldInvalList.remove(c)) {
                    this.listenerLookup.get(c).expect(command, InvalidateL1Command.class);
                } else {
                    this.listenerLookup.get(c).expect(command);
                }
                this.listenerLookup.get(c).waitForRpc();
            }
            for (Cache cache : cachesOnWhichKeyShouldInvalList) {
                this.listenerLookup.get(cache).expect(InvalidateL1Command.class);
                this.listenerLookup.get(cache).waitForRpc();
            }
        }
    }

    @Override
    protected void asyncTxWait(Object ... keys) {
        if (keys != null) {
            HashSet<Cache<Object, String>> cachesInTx = new HashSet<Cache<Object, String>>();
            for (Object k : keys) {
                cachesInTx.addAll(Arrays.asList(this.getOwners(k)));
            }
            this.log.warn((Object)("In asyncTxWait, waiting for repl events on caches " + cachesInTx + " on keys " + Arrays.toString(keys)));
            for (Cache cache : cachesInTx) {
                this.listenerLookup.get(cache).expectAnyWithTx();
                this.listenerLookup.get(cache).waitForRpc(240L, TimeUnit.SECONDS);
            }
            TestingUtil.sleepThread(500 * keys.length);
        }
    }
}

