/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.List;
import java.util.Set;
import org.infinispan.config.Configuration;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.MultipleNodesLeavingTest")
public class MultipleNodesLeavingTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        this.createCluster(MultipleNodesLeavingTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC), 4);
        this.waitForClusterToForm();
    }

    public void testMultipleLeaves() throws Exception {
        this.fork(new Runnable(){

            @Override
            public void run() {
                MultipleNodesLeavingTest.this.manager(3).stop();
            }
        }, false);
        this.fork(new Runnable(){

            @Override
            public void run() {
                MultipleNodesLeavingTest.this.manager(2).stop();
            }
        }, false);
        this.fork(new Runnable(){

            @Override
            public void run() {
                MultipleNodesLeavingTest.this.manager(1).stop();
            }
        }, false);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                List members = MultipleNodesLeavingTest.this.advancedCache(0).getRpcManager().getTransport().getMembers();
                System.out.println("members = " + members);
                return members.size() == 1;
            }
        });
        System.out.println("MultipleNodesLeavingTest.testMultipleLeaves");
        TestingUtil.blockUntilViewsReceived(60000L, false, this.cache(0));
        TestingUtil.waitForRehashToComplete(this.cache(0));
        Set caches = this.advancedCache(0).getDistributionManager().getConsistentHash().getCaches();
        System.out.println("caches = " + caches);
        int size = caches.size();
        assert (size == 1);
    }
}

