/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import org.infinispan.distribution.HashFunction;

class SuperFastHash
extends HashFunction {
    SuperFastHash() {
    }

    @Override
    public int hash(byte[] data) {
        int len;
        if (data == null || data.length == 0) {
            return 0;
        }
        int hash = len = data.length;
        int rem = len & 3;
        len >>= 2;
        int offset = 0;
        while (len > 0) {
            int tmp = this.get16bits(data, offset + 2) << 11 ^ (hash += this.get16bits(data, offset));
            hash = hash << 16 ^ tmp;
            offset += 4;
            hash += hash >> 11;
            --len;
        }
        switch (rem) {
            case 3: {
                hash += this.get16bits(data, offset);
                hash ^= hash << 16;
                hash ^= data[2] << 18;
                hash += hash >> 11;
                break;
            }
            case 2: {
                hash += this.get16bits(data, offset);
                hash ^= hash << 11;
                hash += hash >> 17;
                break;
            }
            case 1: {
                hash += data[0];
                hash ^= hash << 10;
                hash += hash >> 1;
            }
        }
        hash ^= hash << 3;
        hash += hash >> 5;
        hash ^= hash << 4;
        hash += hash >> 17;
        hash ^= hash << 25;
        hash += hash >> 6;
        return hash;
    }

    private int get16bits(byte[] bytes, int offset) {
        short s = bytes[offset];
        s = (short)(s & bytes[offset + 1] << 8);
        return s;
    }

    @Override
    public String functionName() {
        return "SuperFastHash";
    }
}

