/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction;

import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.config.Configuration;
import org.infinispan.eviction.BaseEvictionFunctionalTest;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="eviction.EvictionDuringBatchTest")
public class EvictionDuringBatchTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        Configuration cfg = new Configuration().fluent().eviction().strategy(EvictionStrategy.LRU).maxEntries(Integer.valueOf(128)).expiration().wakeUpInterval(Long.valueOf(100L)).locking().useLockStriping(Boolean.valueOf(false)).invocationBatching().build();
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(cfg);
        this.cache = cm.getCache();
        this.cache.addListener((Object)new BaseEvictionFunctionalTest.EvictionListener());
        return cm;
    }

    public void testEvictionDuringBatchOperations() throws Exception {
        AdvancedCache advancedCache = this.cache.getAdvancedCache();
        for (int i = 0; i < 512; ++i) {
            advancedCache.startBatch();
            this.cache.put((Object)("key-" + (i + 1)), (Object)("value-" + (i + 1)), 1L, TimeUnit.MINUTES);
            advancedCache.endBatch(true);
        }
        Thread.sleep(1000L);
        assert (0 < this.cache.size()) : "no data in cache! all state lost? ";
        assert (512 >= this.cache.size()) : "cache size too big: " + this.cache.size();
    }
}

