/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="eviction.EvictionThreadCountTest")
public class EvictionThreadCountTest
extends SingleCacheManagerTest {
    private static String EVICT_THREAD_NAME_PREFIX = EvictionThreadCountTest.class.getSimpleName() + "-thread";

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfiguration globalCfg = new GlobalConfiguration().fluent().evictionScheduledExecutor().addProperty("threadNamePrefix", EVICT_THREAD_NAME_PREFIX).build();
        return TestCacheManagerFactory.createCacheManager(globalCfg);
    }

    public void testDefineMultipleCachesWithEviction() {
        for (int i = 0; i < 50; ++i) {
            Configuration cfg = new Configuration().fluent().eviction().strategy(EvictionStrategy.LIRS).maxEntries(Integer.valueOf(128)).expiration().wakeUpInterval(Long.valueOf(100L)).locking().useLockStriping(Boolean.valueOf(false)).build();
            String cacheName = Integer.toString(i);
            this.cacheManager.defineConfiguration(cacheName, cfg);
            this.cacheManager.getCache(cacheName);
        }
        ThreadMXBean threadMBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfos = threadMBean.dumpAllThreads(false, false);
        String pattern = "Scheduled-" + EVICT_THREAD_NAME_PREFIX;
        int evictionThreadCount = 0;
        for (ThreadInfo threadInfo : threadInfos) {
            if (!threadInfo.getThreadName().startsWith(pattern)) continue;
            ++evictionThreadCount;
        }
        assert (evictionThreadCount == 1) : "Thread should only be one eviction thread with pattern '" + pattern + "', instead there were " + evictionThreadCount;
    }
}

