/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.invalidation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.easymock.EasyMock;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.api.mvcc.LockAssert;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcManagerImpl;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.locks.LockManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class BaseInvalidationTest
extends MultipleCacheManagersTest {
    protected boolean isSync;

    protected BaseInvalidationTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration c = BaseInvalidationTest.getDefaultClusteredConfig(this.isSync ? Configuration.CacheMode.INVALIDATION_SYNC : Configuration.CacheMode.INVALIDATION_ASYNC, false);
        c.setStateRetrievalTimeout(1000L);
        c.setLockAcquisitionTimeout(500L);
        this.createClusteredCaches(2, "invalidation", c);
        c = BaseInvalidationTest.getDefaultClusteredConfig(this.isSync ? Configuration.CacheMode.INVALIDATION_SYNC : Configuration.CacheMode.INVALIDATION_ASYNC, true);
        c.setStateRetrievalTimeout(1000L);
        c.setLockAcquisitionTimeout(500L);
        this.defineConfigurationOnAllManagers("invalidationTx", c);
        this.waitForClusterToForm("invalidationTx");
    }

    public void testRemove() throws Exception {
        AdvancedCache cache1 = this.cache(0, "invalidation").getAdvancedCache();
        AdvancedCache cache2 = this.cache(1, "invalidation").getAdvancedCache();
        cache1.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)cache1.get((Object)"key"));
        cache2.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)cache2.get((Object)"key"));
        this.replListener((Cache)cache2).expectAny();
        AssertJUnit.assertEquals((Object)"value", (Object)cache1.remove((Object)"key"));
        this.replListener((Cache)cache2).waitForRpc();
        AssertJUnit.assertEquals((boolean)false, (boolean)cache2.containsKey((Object)"key"));
    }

    public void testResurrectEntry() throws Exception {
        AdvancedCache cache1 = this.cache(0, "invalidation").getAdvancedCache();
        AdvancedCache cache2 = this.cache(1, "invalidation").getAdvancedCache();
        this.replListener((Cache)cache2).expect(InvalidateCommand.class);
        cache1.put((Object)"key", (Object)"value");
        this.replListener((Cache)cache2).waitForRpc();
        AssertJUnit.assertEquals((Object)"value", (Object)cache1.get((Object)"key"));
        AssertJUnit.assertEquals(null, (Object)cache2.get((Object)"key"));
        this.replListener((Cache)cache2).expect(InvalidateCommand.class);
        cache1.put((Object)"key", (Object)"newValue");
        this.replListener((Cache)cache2).waitForRpc();
        AssertJUnit.assertEquals((Object)"newValue", (Object)cache1.get((Object)"key"));
        AssertJUnit.assertEquals(null, (Object)cache2.get((Object)"key"));
        this.replListener((Cache)cache2).expect(InvalidateCommand.class);
        AssertJUnit.assertEquals((Object)"newValue", (Object)cache1.remove((Object)"key"));
        this.replListener((Cache)cache2).waitForRpc();
        AssertJUnit.assertEquals(null, (Object)cache1.get((Object)"key"));
        AssertJUnit.assertEquals(null, (Object)cache2.get((Object)"key"));
        this.replListener((Cache)cache2).expect(InvalidateCommand.class);
        cache1.put((Object)"key", (Object)"value");
        this.replListener((Cache)cache2).waitForRpc();
        AssertJUnit.assertEquals((Object)"value", (Object)cache1.get((Object)"key"));
        AssertJUnit.assertEquals(null, (Object)cache2.get((Object)"key"));
        this.replListener((Cache)cache1).expect(InvalidateCommand.class);
        cache2.put((Object)"key", (Object)"value2");
        this.replListener((Cache)cache1).waitForRpc();
        AssertJUnit.assertEquals((Object)"value2", (Object)cache2.get((Object)"key"));
        AssertJUnit.assertEquals(null, (Object)cache1.get((Object)"key"));
    }

    public void testDeleteNonExistentEntry() throws Exception {
        AdvancedCache cache1 = this.cache(0, "invalidationTx").getAdvancedCache();
        AdvancedCache cache2 = this.cache(1, "invalidationTx").getAdvancedCache();
        AssertJUnit.assertNull((String)"Should be null", (Object)cache1.get((Object)"key"));
        AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get((Object)"key"));
        this.log.info((Object)"before...");
        this.replListener((Cache)cache2).expect(InvalidateCommand.class);
        cache1.put((Object)"key", (Object)"value");
        this.log.info((Object)"after...");
        this.replListener((Cache)cache2).waitForRpc();
        AssertJUnit.assertEquals((Object)"value", (Object)cache1.get((Object)"key"));
        AssertJUnit.assertNull((String)"Should be null", (Object)cache2.get((Object)"key"));
        TransactionManager tm = TestingUtil.getTransactionManager((Cache)cache2);
        this.replListener((Cache)cache1).expect(InvalidateCommand.class);
        tm.begin();
        cache2.remove((Object)"key");
        tm.commit();
        this.replListener((Cache)cache1).waitForRpc();
        assert (cache1.get((Object)"key") == null);
        assert (cache2.get((Object)"key") == null);
    }

    public void testTxSyncUnableToInvalidate() throws Exception {
        Transaction tx2;
        TransactionManager mgr2;
        AdvancedCache cache2;
        AdvancedCache cache1;
        block5: {
            cache1 = this.cache(0, "invalidationTx").getAdvancedCache();
            cache2 = this.cache(1, "invalidationTx").getAdvancedCache();
            this.replListener((Cache)cache2).expect(InvalidateCommand.class);
            cache1.put((Object)"key", (Object)"value");
            this.replListener((Cache)cache2).waitForRpc();
            AssertJUnit.assertEquals((Object)"value", (Object)cache1.get((Object)"key"));
            AssertJUnit.assertNull((Object)cache2.get((Object)"key"));
            TransactionManager mgr1 = TestingUtil.getTransactionManager((Cache)cache1);
            mgr2 = TestingUtil.getTransactionManager((Cache)cache2);
            mgr1.begin();
            cache1.put((Object)"key", (Object)"value2");
            Transaction tx1 = mgr1.suspend();
            mgr2.begin();
            cache2.put((Object)"key", (Object)"value3");
            tx2 = mgr2.suspend();
            mgr1.resume(tx1);
            try {
                this.replListener((Cache)cache2).expect(InvalidateCommand.class);
                mgr1.commit();
                this.replListener((Cache)cache2).waitForRpc();
            }
            catch (RollbackException roll) {
                if ($assertionsDisabled || this.isSync) break block5;
                throw new AssertionError((Object)"isSync should be true");
            }
        }
        mgr2.resume(tx2);
        this.replListener((Cache)cache1).expect(InvalidateCommand.class);
        mgr2.commit();
        if (!this.isSync) {
            this.replListener((Cache)cache1).waitForRpc();
        }
        LockManager lm1 = TestingUtil.extractComponent((Cache)cache1, LockManager.class);
        LockManager lm2 = TestingUtil.extractComponent((Cache)cache2, LockManager.class);
        assert (!lm1.isLocked((Object)"key"));
        assert (!lm2.isLocked((Object)"key"));
        LockAssert.assertNoLocks((Cache)cache1);
        LockAssert.assertNoLocks((Cache)cache2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCacheMode() throws Exception {
        AdvancedCache cache1 = this.cache(0, "invalidation").getAdvancedCache();
        AdvancedCache cache2 = this.cache(1, "invalidation").getAdvancedCache();
        RpcManagerImpl rpcManager = (RpcManagerImpl)TestingUtil.extractComponent((Cache)cache1, RpcManager.class);
        Transport origTransport = TestingUtil.extractComponent((Cache)cache1, Transport.class);
        try {
            Transport mockTransport = (Transport)EasyMock.createMock(Transport.class);
            rpcManager.setTransport(mockTransport);
            Address addressOne = (Address)EasyMock.createNiceMock(Address.class);
            Address addressTwo = (Address)EasyMock.createNiceMock(Address.class);
            ArrayList<Address> members = new ArrayList<Address>(2);
            members.add(addressOne);
            members.add(addressTwo);
            EasyMock.expect((Object)mockTransport.getMembers()).andReturn(members).anyTimes();
            EasyMock.expect((Object)mockTransport.getAddress()).andReturn((Object)addressOne).anyTimes();
            EasyMock.expect((Object)mockTransport.invokeRemotely((Collection)((List)EasyMock.anyObject()), (ReplicableCommand)((CacheRpcCommand)EasyMock.anyObject()), (ResponseMode)EasyMock.eq((Object)(this.isSync ? ResponseMode.SYNCHRONOUS : ResponseMode.ASYNCHRONOUS_WITH_SYNC_MARSHALLING)), EasyMock.anyLong(), EasyMock.anyBoolean(), (ResponseFilter)EasyMock.anyObject(), EasyMock.anyBoolean())).andReturn(null).anyTimes();
            EasyMock.replay((Object[])new Object[]{mockTransport});
            cache1.put((Object)"k", (Object)"v");
            EasyMock.verify((Object[])new Object[]{mockTransport});
        }
        finally {
            if (rpcManager != null) {
                rpcManager.setTransport(origTransport);
            }
        }
    }

    public void testPutIfAbsent() {
        AdvancedCache cache1 = this.cache(0, "invalidation").getAdvancedCache();
        AdvancedCache cache2 = this.cache(1, "invalidation").getAdvancedCache();
        assert (null == cache2.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"key", (Object)"value"));
        assert (cache2.get((Object)"key").equals("value"));
        assert (cache1.get((Object)"key") == null);
        this.replListener((Cache)cache2).expect(InvalidateCommand.class);
        cache1.putIfAbsent((Object)"key", (Object)"value");
        this.replListener((Cache)cache2).waitForRpc();
        assert (cache1.get((Object)"key").equals("value"));
        assert (cache2.get((Object)"key") == null);
        assert (null == cache2.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"key", (Object)"value2"));
        assert (cache1.get((Object)"key").equals("value"));
        assert (cache2.get((Object)"key").equals("value2"));
        cache1.putIfAbsent((Object)"key", (Object)"value3");
        assert (cache1.get((Object)"key").equals("value"));
        assert (cache2.get((Object)"key").equals("value2"));
    }

    public void testRemoveIfPresent() {
        AdvancedCache cache1 = this.cache(0, "invalidation").getAdvancedCache();
        AdvancedCache cache2 = this.cache(1, "invalidation").getAdvancedCache();
        cache1.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"key", (Object)"value1");
        cache2.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"key", (Object)"value2");
        assert (cache1.get((Object)"key").equals("value1"));
        assert (cache2.get((Object)"key").equals("value2"));
        assert (!cache1.remove((Object)"key", (Object)"value"));
        assert (cache1.get((Object)"key").equals("value1")) : "Should not remove";
        assert (cache2.get((Object)"key").equals("value2")) : "Should not evict";
        this.replListener((Cache)cache2).expect(InvalidateCommand.class);
        cache1.remove((Object)"key", (Object)"value1");
        this.replListener((Cache)cache2).waitForRpc();
        assert (cache1.get((Object)"key") == null);
        assert (cache2.get((Object)"key") == null);
    }

    public void testClear() {
        AdvancedCache cache1 = this.cache(0, "invalidation").getAdvancedCache();
        AdvancedCache cache2 = this.cache(1, "invalidation").getAdvancedCache();
        cache1.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"key", (Object)"value1");
        cache2.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"key", (Object)"value2");
        assert (cache1.get((Object)"key").equals("value1"));
        assert (cache2.get((Object)"key").equals("value2"));
        this.replListener((Cache)cache2).expect(ClearCommand.class);
        cache1.clear();
        this.replListener((Cache)cache2).waitForRpc();
        assert (cache1.get((Object)"key") == null);
        assert (cache2.get((Object)"key") == null);
    }

    public void testReplace() {
        AdvancedCache cache1 = this.cache(0, "invalidation").getAdvancedCache();
        AdvancedCache cache2 = this.cache(1, "invalidation").getAdvancedCache();
        cache2.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"key", (Object)"value2");
        assert (cache1.get((Object)"key") == null);
        assert (cache2.get((Object)"key").equals("value2"));
        assert (null == cache1.replace((Object)"key", (Object)"value1"));
        assert (cache1.get((Object)"key") == null);
        assert (cache2.get((Object)"key").equals("value2"));
        assert (null == cache1.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"key", (Object)"valueN"));
        this.replListener((Cache)cache2).expect(InvalidateCommand.class);
        cache1.replace((Object)"key", (Object)"value1");
        this.replListener((Cache)cache2).waitForRpc();
        assert (cache1.get((Object)"key").equals("value1"));
        assert (cache2.get((Object)"key") == null);
    }

    public void testReplaceWithOldVal() {
        AdvancedCache cache1 = this.cache(0, "invalidation").getAdvancedCache();
        AdvancedCache cache2 = this.cache(1, "invalidation").getAdvancedCache();
        cache2.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"key", (Object)"value2");
        assert (cache1.get((Object)"key") == null);
        assert (cache2.get((Object)"key").equals("value2"));
        assert (!cache1.replace((Object)"key", (Object)"valueOld", (Object)"value1"));
        assert (cache1.get((Object)"key") == null);
        assert (cache2.get((Object)"key").equals("value2"));
        assert (null == cache1.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"key", (Object)"valueN"));
        assert (!cache1.replace((Object)"key", (Object)"valueOld", (Object)"value1"));
        assert (cache1.get((Object)"key").equals("valueN"));
        assert (cache2.get((Object)"key").equals("value2"));
        this.replListener((Cache)cache2).expect(InvalidateCommand.class);
        assert (cache1.replace((Object)"key", (Object)"valueN", (Object)"value1"));
        this.replListener((Cache)cache2).waitForRpc();
        assert (cache1.get((Object)"key").equals("value1"));
        assert (cache2.get((Object)"key") == null);
    }

    public void testLocalOnlyClear() {
        AdvancedCache cache1 = this.cache(0, "invalidation").getAdvancedCache();
        AdvancedCache cache2 = this.cache(1, "invalidation").getAdvancedCache();
        cache1.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"key", (Object)"value1");
        cache2.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"key", (Object)"value2");
        assert (cache1.get((Object)"key").equals("value1"));
        assert (cache2.get((Object)"key").equals("value2"));
        cache1.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).clear();
        assert (cache1.get((Object)"key") == null);
        assert (cache2.get((Object)"key") != null);
        assert (cache2.get((Object)"key").equals("value2"));
    }

    public void testPutForExternalRead() throws Exception {
        AdvancedCache cache1 = this.cache(0, "invalidation").getAdvancedCache();
        AdvancedCache cache2 = this.cache(1, "invalidation").getAdvancedCache();
        cache1.putForExternalRead((Object)"key", (Object)"value1");
        Thread.sleep(500L);
        cache2.putForExternalRead((Object)"key", (Object)"value2");
        Thread.sleep(500L);
        assert (cache1.get((Object)"key") != null);
        assert (cache1.get((Object)"key").equals("value1"));
        assert (cache2.get((Object)"key") != null);
        assert (cache2.get((Object)"key").equals("value2"));
    }
}

