/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.jmx.PerThreadMBeanServerLookup;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.CacheLoaderAndCacheStoreInterceptorMBeanTest")
public class CacheLoaderAndCacheStoreInterceptorMBeanTest
extends SingleCacheManagerTest {
    private ObjectName loaderInterceptorObjName;
    private ObjectName storeInterceptorObjName;
    private MBeanServer threadMBeanServer;
    private CacheStore cacheStore;
    private static final String JMX_DOMAIN = CacheLoaderAndCacheStoreInterceptorMBeanTest.class.getName();

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfiguration globalConfiguration = GlobalConfiguration.getNonClusteredDefault();
        globalConfiguration.setMBeanServerLookup(PerThreadMBeanServerLookup.class.getName());
        globalConfiguration.setJmxDomain(JMX_DOMAIN);
        globalConfiguration.setExposeGlobalJmxStatistics(true);
        this.cacheManager = TestCacheManagerFactory.createCacheManagerEnforceJmxDomain(globalConfiguration);
        DummyInMemoryCacheStore.Cfg cfg = new DummyInMemoryCacheStore.Cfg();
        CacheLoaderManagerConfig clManagerConfig = new CacheLoaderManagerConfig();
        clManagerConfig.setPassivation(Boolean.valueOf(false));
        clManagerConfig.addCacheLoaderConfig((CacheLoaderConfig)cfg);
        Configuration configuration = CacheLoaderAndCacheStoreInterceptorMBeanTest.getDefaultClusteredConfig(Configuration.CacheMode.LOCAL);
        configuration.setExposeJmxStatistics(true);
        configuration.setCacheLoaderManagerConfig(clManagerConfig);
        this.cacheManager.defineConfiguration("test", configuration);
        this.cache = this.cacheManager.getCache("test");
        this.loaderInterceptorObjName = TestingUtil.getCacheObjectName(JMX_DOMAIN, "test(local)", "CacheLoader");
        this.storeInterceptorObjName = TestingUtil.getCacheObjectName(JMX_DOMAIN, "test(local)", "CacheStore");
        this.threadMBeanServer = PerThreadMBeanServerLookup.getThreadMBeanServer();
        this.cacheStore = TestingUtil.extractComponent(this.cache, CacheLoaderManager.class).getCacheStore();
        return this.cacheManager;
    }

    @AfterMethod
    public void resetStats() throws Exception {
        this.threadMBeanServer.invoke(this.loaderInterceptorObjName, "resetStatistics", new Object[0], new String[0]);
        this.threadMBeanServer.invoke(this.storeInterceptorObjName, "resetStatistics", new Object[0], new String[0]);
    }

    public void testPutKeyValue() throws Exception {
        this.assertStoreAccess(0, 0, 0);
        this.cache.put((Object)"key", (Object)"value");
        this.assertStoreAccess(0, 0, 1);
        this.cache.put((Object)"key", (Object)"value2");
        this.assertStoreAccess(0, 0, 2);
        this.cacheStore.store(TestInternalCacheEntryFactory.create("a", "b"));
        this.cache.put((Object)"a", (Object)"c");
        this.assertStoreAccess(1, 0, 3);
        assert (this.cacheStore.load((Object)"a").getValue().equals("c"));
    }

    public void testGetValue() throws Exception {
        this.assertStoreAccess(0, 0, 0);
        this.cache.put((Object)"key", (Object)"value");
        this.assertStoreAccess(0, 0, 1);
        assert (this.cache.get((Object)"key").equals("value"));
        this.assertStoreAccess(0, 0, 1);
        this.cacheStore.store(TestInternalCacheEntryFactory.create("a", "b"));
        assert (this.cache.get((Object)"a").equals("b"));
        this.assertStoreAccess(1, 0, 1);
        assert (this.cache.get((Object)"no_such_key") == null);
        this.assertStoreAccess(1, 1, 1);
    }

    public void testRemoveValue() throws Exception {
        this.assertStoreAccess(0, 0, 0);
        this.cache.put((Object)"key", (Object)"value");
        this.assertStoreAccess(0, 0, 1);
        assert (this.cache.get((Object)"key").equals("value"));
        this.assertStoreAccess(0, 0, 1);
        assert (this.cache.remove((Object)"key").equals("value"));
        this.assertStoreAccess(0, 0, 1);
        this.cache.remove((Object)"no_such_key");
        this.assertStoreAccess(0, 1, 1);
        this.cacheStore.store(TestInternalCacheEntryFactory.create("a", "b"));
        assert (this.cache.remove((Object)"a").equals("b"));
        this.assertStoreAccess(1, 1, 1);
    }

    public void testReplaceCommand() throws Exception {
        this.assertStoreAccess(0, 0, 0);
        this.cache.put((Object)"key", (Object)"value");
        this.assertStoreAccess(0, 0, 1);
        assert (this.cache.replace((Object)"key", (Object)"value2").equals("value"));
        this.assertStoreAccess(0, 0, 2);
        this.cacheStore.store(TestInternalCacheEntryFactory.create("a", "b"));
        assert (this.cache.replace((Object)"a", (Object)"c").equals("b"));
        this.assertStoreAccess(1, 0, 3);
        assert (this.cache.replace((Object)"no_such_key", (Object)"c") == null);
        this.assertStoreAccess(1, 1, 3);
    }

    private void assertStoreAccess(int loadsCount, int missesCount, int storeCount) throws Exception {
        this.assertLoadCount(loadsCount, missesCount);
        this.assertStoreCount(storeCount);
    }

    private void assertLoadCount(int loadsCount, int missesCount) throws Exception {
        Object actualLoadCount = this.threadMBeanServer.getAttribute(this.loaderInterceptorObjName, "CacheLoaderLoads");
        assert (Integer.valueOf(actualLoadCount.toString()).equals(loadsCount)) : "expected " + loadsCount + " loads count and received " + actualLoadCount;
        Object actualMissesCount = this.threadMBeanServer.getAttribute(this.loaderInterceptorObjName, "CacheLoaderMisses");
        assert (Integer.valueOf(actualMissesCount.toString()).equals(missesCount)) : "expected " + missesCount + " misses count, and received " + actualMissesCount;
    }

    private void assertStoreCount(int count) throws Exception {
        Object actualStoreCount = this.threadMBeanServer.getAttribute(this.storeInterceptorObjName, "CacheLoaderStores");
        assert (Integer.valueOf(actualStoreCount.toString()).equals(count)) : "expected " + count + " store counts, but received " + actualStoreCount;
    }
}

