/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders;

import org.infinispan.Cache;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.cluster.ClusterCacheLoaderConfig;
import org.infinispan.loaders.decorators.ChainingCacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.ClusterCacheLoaderTest")
public class ClusterCacheLoaderTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        EmbeddedCacheManager cacheManager1 = TestCacheManagerFactory.createClusteredCacheManager();
        EmbeddedCacheManager cacheManager2 = TestCacheManagerFactory.createClusteredCacheManager();
        this.registerCacheManager(new CacheContainer[]{cacheManager1, cacheManager2});
        Configuration config1 = ClusterCacheLoaderTest.getDefaultClusteredConfig(Configuration.CacheMode.INVALIDATION_SYNC);
        ClusterCacheLoaderConfig clusterClc = new ClusterCacheLoaderConfig();
        CacheLoaderManagerConfig clMngrConfig = new CacheLoaderManagerConfig();
        clMngrConfig.addCacheLoaderConfig((CacheLoaderConfig)clusterClc);
        config1.setCacheLoaderManagerConfig(clMngrConfig);
        Configuration config2 = ClusterCacheLoaderTest.getDefaultClusteredConfig(Configuration.CacheMode.INVALIDATION_SYNC);
        CacheLoaderManagerConfig clMngrConfig2 = clMngrConfig.clone();
        clMngrConfig2.addCacheLoaderConfig((CacheLoaderConfig)new DummyInMemoryCacheStore.Cfg());
        assert (clMngrConfig2.getCacheLoaderConfigs().size() == 2);
        config2.setCacheLoaderManagerConfig(clMngrConfig2);
        cacheManager1.defineConfiguration("clusteredCl", config1);
        cacheManager2.defineConfiguration("clusteredCl", config2);
        Cache cache1 = this.cache(0, "clusteredCl");
        Cache cache2 = this.cache(1, "clusteredCl");
    }

    public void testRemoteLoad() {
        Cache cache1 = this.cache(0, "clusteredCl");
        Cache cache2 = this.cache(1, "clusteredCl");
        assert (cache1.get((Object)"key") == null);
        assert (cache1.get((Object)"key") == null);
        cache2.put((Object)"key", (Object)"value");
        assert ("value".equals(cache1.get((Object)"key")));
    }

    public void testRemoteLoadFromCacheLoader() throws Exception {
        Cache cache1 = this.cache(0, "clusteredCl");
        Cache cache2 = this.cache(1, "clusteredCl");
        CacheLoaderManager manager2 = (CacheLoaderManager)cache2.getAdvancedCache().getComponentRegistry().getComponent(CacheLoaderManager.class);
        ChainingCacheStore chainingCacheStore = (ChainingCacheStore)manager2.getCacheStore();
        CacheStore cs2 = (CacheStore)chainingCacheStore.getStores().keySet().iterator().next();
        assert (cache1.get((Object)"key") == null);
        assert (cache2.get((Object)"key") == null);
        cs2.store(TestInternalCacheEntryFactory.create("key", "value"));
        assert (cs2.load((Object)"key").getValue().equals("value"));
        assert (cache1.get((Object)"key").equals("value"));
    }
}

