/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.config.CloneableConfigurationComponent;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.InvocationContextInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loaders.ConcurrentLoadAndEvictTest")
public class ConcurrentLoadAndEvictTest
extends SingleCacheManagerTest {
    SlowDownInterceptor sdi;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.sdi = new SlowDownInterceptor();
        Configuration config = new Configuration().fluent().loaders().addCacheLoader(new CacheLoaderConfig[]{new DummyInMemoryCacheStore.Cfg()}).customInterceptors().add((CommandInterceptor)this.sdi).after(InvocationContextInterceptor.class).transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL).build();
        return TestCacheManagerFactory.createCacheManager(config);
    }

    public void testEvictBeforeRead() throws CacheLoaderException, ExecutionException, InterruptedException {
        this.cache = this.cacheManager.getCache();
        this.cache.put((Object)"a", (Object)"b");
        assert (this.cache.get((Object)"a").equals("b"));
        CacheLoader cl = TestingUtil.getCacheLoader(this.cache);
        assert (cl != null);
        InternalCacheEntry se = cl.load((Object)"a");
        assert (se != null);
        assert (se.getValue().equals("b"));
        this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).clear();
        se = cl.load((Object)"a");
        assert (se != null);
        assert (se.getValue().equals("b"));
        ExecutorService e = Executors.newFixedThreadPool(1);
        this.sdi.enabled = true;
        this.log.info((Object)"test::doing the get");
        Future<String> future = e.submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return (String)ConcurrentLoadAndEvictTest.this.cache.get((Object)"a");
            }
        });
        this.log.info((Object)"test::before the evict");
        this.cache.evict((Object)"a");
        this.log.info((Object)"test::after the evict");
        assert (future.get().equals("b"));
        this.sdi.enabled = false;
        assert (!TestingUtil.extractComponent(this.cache, DataContainer.class).containsKey((Object)"a"));
        e.shutdownNow();
    }

    public static class SlowDownInterceptor
    extends CommandInterceptor
    implements CloneableConfigurationComponent {
        private static final long serialVersionUID = 8790944676490291484L;
        volatile boolean enabled = false;
        transient CountDownLatch getLatch = new CountDownLatch(1);
        transient CountDownLatch evictLatch = new CountDownLatch(1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
            if (this.enabled) {
                this.getLog().trace((Object)"Wait for evict to give go ahead...");
                if (!this.evictLatch.await(60000L, TimeUnit.MILLISECONDS)) {
                    throw new TimeoutException("Didn't see get after 60 seconds!");
                }
            }
            try {
                Object object = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
                return object;
            }
            finally {
                this.getLog().trace((Object)"After get, now let evict go through");
                if (this.enabled) {
                    this.getLatch.countDown();
                }
            }
        }

        public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
            if (this.enabled) {
                this.evictLatch.countDown();
                this.getLog().trace((Object)"Wait for get to finish...");
                if (!this.getLatch.await(60000L, TimeUnit.MILLISECONDS)) {
                    throw new TimeoutException("Didn't see evict after 60 seconds!");
                }
            }
            return this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        }

        public SlowDownInterceptor clone() {
            try {
                return (SlowDownInterceptor)((Object)super.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("Should not happen", e);
            }
        }
    }
}

