/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.keymappers;

import org.infinispan.loaders.keymappers.DefaultTwoWayKey2StringMapper;
import org.infinispan.util.ByteArrayKey;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="loaders.keymappers.DefaultTwoWayKey2StringMapperTest")
public class DefaultTwoWayKey2StringMapperTest {
    DefaultTwoWayKey2StringMapper mapper = new DefaultTwoWayKey2StringMapper();

    public void testKeyMapper() {
        String skey = this.mapper.getStringMapping((Object)"k1");
        assert (skey.equals("k1"));
        skey = this.mapper.getStringMapping((Object)100);
        assert (!skey.equals("100"));
        Integer i = (Integer)this.mapper.getKeyMapping(skey);
        assert (i == 100);
        skey = this.mapper.getStringMapping((Object)Boolean.TRUE);
        assert (!skey.equalsIgnoreCase("true"));
        Boolean b = (Boolean)this.mapper.getKeyMapping(skey);
        assert (b.booleanValue());
        skey = this.mapper.getStringMapping((Object)3.141592);
        assert (!skey.equals("3.141592"));
        Double d = (Double)this.mapper.getKeyMapping(skey);
        assert (d == 3.141592);
        byte[] bytes = new byte[]{0, 1, 2, 40, -128, -127, 127, 126, 0};
        skey = this.mapper.getStringMapping((Object)new ByteArrayKey(bytes));
        assert (!skey.equals("\u0000\u0001\u0002(\u001f7\u001f6\u000f7\u000f6\u0000"));
    }

    public void testPrimitivesAreSupported() {
        assert (this.mapper.isSupportedType(Integer.class));
        assert (this.mapper.isSupportedType(Byte.class));
        assert (this.mapper.isSupportedType(Short.class));
        assert (this.mapper.isSupportedType(Long.class));
        assert (this.mapper.isSupportedType(Double.class));
        assert (this.mapper.isSupportedType(Float.class));
        assert (this.mapper.isSupportedType(Boolean.class));
        assert (this.mapper.isSupportedType(String.class));
        assert (this.mapper.isSupportedType(ByteArrayKey.class));
    }

    public void testTwoWayContract() {
        Object[] toTest;
        for (Object o : toTest = new Object[]{0, new Byte("1"), new Short("2"), 3L, new Double("3.4"), new Float("3.5"), Boolean.FALSE, "some string", new ByteArrayKey("\u0000\u0001\u0002(\u001f7\u001f6\u000f7\u000f6\u0000".getBytes())}) {
            Class<?> type = o.getClass();
            String rep = this.mapper.getStringMapping(o);
            assert (o.equals(this.mapper.getKeyMapping(rep))) : String.format("Failed on type %s and value %s", type, rep);
        }
    }

    public void testAssumption() {
        assert (!new Float(3.0f).equals(new Integer(3)));
    }

    public void testString() {
        assert (this.mapper.isSupportedType(String.class));
        assert (this.assertWorks("")) : "Expected empty string, was " + this.mapper.getStringMapping((Object)"");
        assert (this.assertWorks("mircea")) : "Expected 'mircea', was " + this.mapper.getStringMapping((Object)"mircea");
    }

    public void testShort() {
        assert (this.mapper.isSupportedType(Short.class));
        assert (this.assertWorks((short)2));
    }

    public void testByte() {
        assert (this.mapper.isSupportedType(Byte.class));
        assert (this.assertWorks((byte)2));
    }

    public void testLong() {
        assert (this.mapper.isSupportedType(Long.class));
        assert (this.assertWorks(new Long(2L)));
    }

    public void testInteger() {
        assert (this.mapper.isSupportedType(Integer.class));
        assert (this.assertWorks(2));
    }

    public void testDouble() {
        assert (this.mapper.isSupportedType(Double.class));
        assert (this.assertWorks(2.4));
    }

    public void testFloat() {
        assert (this.mapper.isSupportedType(Float.class));
        assert (this.assertWorks(Float.valueOf(2.1f)));
    }

    public void testBoolean() {
        assert (this.mapper.isSupportedType(Boolean.class));
        assert (this.assertWorks(true));
        assert (this.assertWorks(false));
    }

    public void testByteArrayKey() {
        assert (this.mapper.isSupportedType(ByteArrayKey.class));
        assert (this.assertWorks(new ByteArrayKey("\u0000\u0001\u0002(\u001f7\u001f6\u000f7\u000f6\u0000".getBytes())));
    }

    private boolean assertWorks(Object key) {
        return this.mapper.getKeyMapping(this.mapper.getStringMapping(key)).equals(key);
    }
}

