/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import org.infinispan.config.Configuration;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.lock.CheckRemoteLockAcquiredOnlyOnceTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.transaction.LockingMode;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.CheckNoRemoteCallForLocalKeyTest")
public class CheckNoRemoteCallForLocalKeyTest
extends MultipleCacheManagersTest {
    protected CheckRemoteLockAcquiredOnlyOnceTest.ControlInterceptor controlInterceptor;
    protected Configuration.CacheMode mode = Configuration.CacheMode.REPL_SYNC;
    protected Object key = "k";

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration c = CheckNoRemoteCallForLocalKeyTest.getDefaultClusteredConfig(this.mode, true);
        c.fluent().transaction().lockingMode(LockingMode.PESSIMISTIC);
        this.createCluster(c, 2);
        this.waitForClusterToForm();
        this.controlInterceptor = new CheckRemoteLockAcquiredOnlyOnceTest.ControlInterceptor();
        this.cache(1).getAdvancedCache().addInterceptor((CommandInterceptor)this.controlInterceptor, 1);
    }

    public void testLocalPut() throws Exception {
        this.testLocalOperation(new CheckRemoteLockAcquiredOnlyOnceTest.CacheOperation(){

            @Override
            public void execute() {
                CheckNoRemoteCallForLocalKeyTest.this.cache(0).put(CheckNoRemoteCallForLocalKeyTest.this.key, (Object)"v");
            }
        });
    }

    public void testLocalRemove() throws Exception {
        this.testLocalOperation(new CheckRemoteLockAcquiredOnlyOnceTest.CacheOperation(){

            @Override
            public void execute() {
                CheckNoRemoteCallForLocalKeyTest.this.cache(0).remove(CheckNoRemoteCallForLocalKeyTest.this.key);
            }
        });
    }

    public void testLocalReplace() throws Exception {
        this.testLocalOperation(new CheckRemoteLockAcquiredOnlyOnceTest.CacheOperation(){

            @Override
            public void execute() {
                CheckNoRemoteCallForLocalKeyTest.this.cache(0).replace(CheckNoRemoteCallForLocalKeyTest.this.key, (Object)"", (Object)"");
            }
        });
    }

    public void testLocalLock() throws Exception {
        this.testLocalOperation(new CheckRemoteLockAcquiredOnlyOnceTest.CacheOperation(){

            @Override
            public void execute() {
                CheckNoRemoteCallForLocalKeyTest.this.cache(0).getAdvancedCache().lock(new Object[]{CheckNoRemoteCallForLocalKeyTest.this.key});
            }
        });
    }

    private void testLocalOperation(CheckRemoteLockAcquiredOnlyOnceTest.CacheOperation o) throws Exception {
        assert (!this.advancedCache(1).getRpcManager().getTransport().isCoordinator());
        assert (this.advancedCache(0).getRpcManager().getTransport().isCoordinator());
        this.tm(0).begin();
        o.execute();
        assert (this.lockManager(0).isLocked(this.key));
        assert (!this.lockManager(1).isLocked(this.key));
        Assert.assertEquals((int)this.controlInterceptor.remoteInvocations, (int)0);
        this.tm(0).rollback();
    }
}

