/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.infinispan.CacheException;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;

class FailInterceptor
extends CommandInterceptor {
    public Queue<Action> actions = new LinkedBlockingQueue<Action>();

    FailInterceptor() {
    }

    protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        Action action = this.actions.peek();
        if (action == null || !command.getClass().equals(action.commandClass)) {
            return super.handleDefault(ctx, command);
        }
        --action.count;
        if (action.count <= 0) {
            this.actions.poll();
        }
        switch (action.type) {
            case EXEC: {
                return super.handleDefault(ctx, command);
            }
            case SKIP: {
                this.getLog().debugf("Skipped executing command %s", (Object)command);
                return action.returnValue;
            }
            case FAIL: {
                throw new CacheException("Forced failure executing command " + command);
            }
        }
        throw new CacheException("Unexpected FailInterceptor action type: " + (Object)((Object)action.type));
    }

    public void failFor(Class<? extends ReplicableCommand> commandClass) {
        this.failFor(commandClass, Integer.MAX_VALUE);
    }

    public void failFor(Class<? extends ReplicableCommand> commandClass, int failCount) {
        this.actions.add(new Action(ActionType.FAIL, commandClass, null, failCount));
    }

    public void skipFor(Class<? extends ReplicableCommand> commandClass, Object returnValue) {
        this.skipFor(commandClass, returnValue, Integer.MAX_VALUE);
    }

    public void skipFor(Class<? extends ReplicableCommand> commandClass, Object returnValue, int skipCount) {
        this.actions.add(new Action(ActionType.SKIP, commandClass, returnValue, skipCount));
    }

    public void execFor(Class<? extends ReplicableCommand> commandClass) {
        this.execFor(commandClass, Integer.MAX_VALUE);
    }

    public void execFor(Class<? extends ReplicableCommand> commandClass, int execCount) {
        this.actions.add(new Action(ActionType.EXEC, commandClass, null, execCount));
    }

    private static class Action {
        public Class commandClass;
        public ActionType type;
        public Object returnValue;
        public int count;

        private Action(ActionType type, Class commandClass, Object returnValue, int count) {
            this.commandClass = commandClass;
            this.type = type;
            this.returnValue = returnValue;
            this.count = count;
        }
    }

    private static enum ActionType {
        EXEC,
        SKIP,
        FAIL;

    }
}

