/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="manager.CacheManagerXmlConfigurationTest")
public class CacheManagerXmlConfigurationTest
extends AbstractInfinispanTest {
    EmbeddedCacheManager cm;

    @AfterMethod
    public void tearDown() {
        if (this.cm != null) {
            this.cm.stop();
        }
        this.cm = null;
    }

    public void testNamedCacheXML() throws IOException {
        this.cm = TestCacheManagerFactory.fromXml("configs/named-cache-test.xml");
        Assert.assertEquals((String)"s1", (String)this.cm.getGlobalConfiguration().getSiteId());
        Assert.assertEquals((String)"r1", (String)this.cm.getGlobalConfiguration().getRackId());
        Assert.assertEquals((String)"m1", (String)this.cm.getGlobalConfiguration().getMachineId());
        Cache c = this.cm.getCache();
        assert (c.getConfiguration().getConcurrencyLevel() == 100);
        assert (c.getConfiguration().getLockAcquisitionTimeout() == 1000L);
        assert (!c.getConfiguration().isTransactionalCache());
        Assert.assertEquals((Object)c.getConfiguration().getTransactionMode(), (Object)TransactionMode.NON_TRANSACTIONAL);
        assert (TestingUtil.extractComponent(c, Transport.class) != null) : "This should not be null, since a shared transport should be present";
        c = this.cm.getCache("transactional");
        assert (c.getConfiguration().isTransactionalCache());
        assert (c.getConfiguration().getConcurrencyLevel() == 100);
        assert (c.getConfiguration().getLockAcquisitionTimeout() == 1000L);
        assert (TestingUtil.extractComponent(c, TransactionManager.class) != null);
        assert (TestingUtil.extractComponent(c, Transport.class) != null) : "This should not be null, since a shared transport should be present";
        c = this.cm.getCache("syncRepl");
        assert (c.getConfiguration().getConcurrencyLevel() == 100);
        assert (c.getConfiguration().getLockAcquisitionTimeout() == 1000L);
        Assert.assertEquals((Object)c.getConfiguration().getTransactionMode(), (Object)TransactionMode.NON_TRANSACTIONAL);
        assert (TestingUtil.extractComponent(c, Transport.class) != null) : "This should not be null, since a shared transport should be present";
        c = this.cm.getCache("txSyncRepl");
        assert (c.getConfiguration().getConcurrencyLevel() == 100);
        assert (c.getConfiguration().getLockAcquisitionTimeout() == 1000L);
        assert (TestingUtil.extractComponent(c, TransactionManager.class) != null);
        assert (TestingUtil.extractComponent(c, Transport.class) != null) : "This should not be null, since a shared transport should be present";
    }

    public void testNamedCacheXMLClashingNames() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:5.1 http://www.infinispan.org/schemas/infinispan-config-5.1.xsd\"\n      xmlns=\"urn:infinispan:config:5.1\">\n    <default>\n        <locking concurrencyLevel=\"100\" lockAcquisitionTimeout=\"1000\" />\n    </default>\n\n    <namedCache name=\"c1\">\n        <transaction transactionManagerLookupClass=\"org.infinispan.transaction.GenericTransactionManagerLookup\"/>\n    </namedCache>\n\n    <namedCache name=\"c1\">\n        <clustering>\n            <sync replTimeout=\"15000\"/>\n        </clustering>\n    </namedCache>\n</infinispan>";
        ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes());
        try {
            this.cm = TestCacheManagerFactory.fromStream(bais);
            assert (false) : "Should fail";
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void testNamedCacheXMLClashingNamesProgrammatic() throws IOException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:5.1 http://www.infinispan.org/schemas/infinispan-config-5.1.xsd\"\n      xmlns=\"urn:infinispan:config:5.1\">\n<global/>\n    <default>\n        <locking concurrencyLevel=\"100\" lockAcquisitionTimeout=\"1000\" />\n    </default>\n\n    <namedCache name=\"c1\">\n        <transaction transactionManagerLookupClass=\"org.infinispan.transaction.lookup.GenericTransactionManagerLookup\"/>\n    </namedCache>\n</infinispan>";
        ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes());
        this.cm = TestCacheManagerFactory.fromStream(bais);
        assert (this.cm.getCache() != null);
        assert (this.cm.getCache("c1") != null);
        Configuration c1Config = this.cm.getCache("c1").getConfiguration();
        assert (c1Config != null);
        Configuration redefinedConfig = this.cm.defineConfiguration("c1", new Configuration());
        assert (c1Config.equals((Object)redefinedConfig));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeprecatedElements() throws Exception {
        EmbeddedCacheManager cm = TestCacheManagerFactory.fromXml("configs/deprecated-elements.xml");
        try {
            Cache[] caches;
            for (Cache c : caches = new Cache[]{cm.getCache("storeAsBinary"), cm.getCache()}) {
                assert (c.getCacheConfiguration().storeAsBinary().enabled());
                assert (c.getCacheConfiguration().expiration().wakeUpInterval() == 12000L);
            }
        }
        finally {
            cm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBatchingIsEnabled() throws Exception {
        EmbeddedCacheManager cm = TestCacheManagerFactory.fromXml("configs/batching.xml");
        try {
            Cache c = cm.getCache("any");
            assert (c.getConfiguration().isInvocationBatchingEnabled());
            assert (c.getConfiguration().isTransactionalCache());
            c = cm.getCache();
            assert (c.getConfiguration().isInvocationBatchingEnabled());
            Cache c2 = cm.getCache("tml");
            assert (c2.getConfiguration().isTransactionalCache());
        }
        finally {
            cm.stop();
        }
    }
}

