/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall;

import com.thoughtworks.xstream.XStream;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.infinispan.io.ByteBuffer;
import org.infinispan.io.ExposedByteArrayOutputStream;
import org.infinispan.marshall.AbstractMarshaller;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.util.Util;

public class TestObjectStreamMarshaller
extends AbstractMarshaller
implements StreamingMarshaller {
    XStream xs = new XStream();
    boolean debugXml = false;

    public TestObjectStreamMarshaller(boolean debugXml) {
        this.debugXml = debugXml;
    }

    public TestObjectStreamMarshaller() {
    }

    public ObjectOutput startObjectOutput(OutputStream os, boolean isReentrant, int expectedByteSize) throws IOException {
        return new ObjectOutputStream(os);
    }

    @Deprecated
    public ObjectOutput startObjectOutput(OutputStream os, boolean isReentrant) throws IOException {
        throw new IllegalStateException("Should not invoke deprecated method anymore");
    }

    public void finishObjectOutput(ObjectOutput oo) {
        Util.flushAndCloseOutput((ObjectOutput)oo);
    }

    public void objectToObjectStream(Object obj, ObjectOutput out) throws IOException {
        String xml = this.xs.toXML(obj);
        this.debug("Writing: \n" + xml);
        out.writeObject(xml);
    }

    public Object objectFromObjectStream(ObjectInput in) throws IOException, ClassNotFoundException {
        String xml = (String)in.readObject();
        this.debug("Reading: \n" + xml);
        return this.xs.fromXML(xml);
    }

    public ObjectInput startObjectInput(InputStream is, boolean isReentrant) throws IOException {
        return new ObjectInputStream(is);
    }

    public void finishObjectInput(ObjectInput oi) {
        if (oi != null) {
            try {
                oi.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected ByteBuffer objectToBuffer(Object o, int estimatedSize) throws IOException {
        ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream(estimatedSize);
        ObjectOutputStream oos = new ObjectOutputStream((OutputStream)baos);
        this.objectToObjectStream(o, oos);
        oos.flush();
        oos.close();
        baos.close();
        byte[] b = baos.toByteArray();
        return new ByteBuffer(b, 0, b.length);
    }

    public Object objectFromByteBuffer(byte[] buf, int offset, int length) throws IOException, ClassNotFoundException {
        byte[] newBytes = new byte[length];
        System.arraycopy(buf, offset, newBytes, 0, length);
        return this.objectFromObjectStream(new ObjectInputStream(new ByteArrayInputStream(buf)));
    }

    public boolean isMarshallable(Object o) {
        return o instanceof Serializable || o instanceof Externalizable;
    }

    private void debug(String s) {
        if (this.debugXml) {
            System.out.println("TestObjectStreamMarshaller: " + s);
        }
    }

    public void stop() {
    }
}

