/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.jgroups;

import java.util.Properties;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="remoting.MissingRpcDispatcherTest")
@CleanupAfterMethod
public class MissingRpcDispatcherTest
extends MultipleCacheManagersTest {
    protected String cacheName = "replSync";
    protected Configuration.CacheMode cacheMode = Configuration.CacheMode.REPL_SYNC;

    @Override
    protected void createCacheManagers() throws Exception {
        Configuration c = MissingRpcDispatcherTest.getDefaultClusteredConfig(this.cacheMode);
        c.fluent().clustering().stateRetrieval().fetchInMemoryState(Boolean.valueOf(true));
        this.createClusteredCaches(1, this.cacheName, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExtraChannelWithoutRpcDispatcher() throws Exception {
        Cache cache1 = this.cache(0, this.cacheName);
        cache1.put((Object)"k1", (Object)"v1");
        assert ("v1".equals(cache1.get((Object)"k1")));
        Channel channel2 = this.createJGroupsChannel(this.manager(0).getGlobalConfiguration());
        try {
            cache1.put((Object)"k2", (Object)"v2");
            assert ("v2".equals(cache1.get((Object)"k2")));
            Configuration c = MissingRpcDispatcherTest.getDefaultClusteredConfig(this.cacheMode);
            c.fluent().clustering().stateRetrieval().fetchInMemoryState(Boolean.valueOf(true));
            EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(new TransportFlags());
            cm.defineConfiguration(this.cacheName, c);
            Cache cache2 = cm.getCache(this.cacheName);
            assert (cache2.getAdvancedCache().getRpcManager().getTransport().getMembers().size() == 3);
            assert ("v1".equals(cache1.get((Object)"k1")));
            assert ("v2".equals(cache1.get((Object)"k2")));
            cache1.put((Object)"k1", (Object)"v1_2");
            cache2.put((Object)"k2", (Object)"v2_2");
            assert ("v1_2".equals(cache1.get((Object)"k1")));
            assert ("v2_2".equals(cache1.get((Object)"k2")));
        }
        finally {
            channel2.close();
        }
    }

    private Channel createJGroupsChannel(GlobalConfiguration gc) {
        GlobalConfiguration newGC = gc.clone();
        TestCacheManagerFactory.amendTransport(newGC);
        Properties p = newGC.getTransportProperties();
        String jgroupsCfg = p.getProperty("configurationString");
        try {
            JChannel channel = new JChannel(jgroupsCfg);
            channel.connect(newGC.getClusterName());
            return channel;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }
}

