/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.replication;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.AdvancedCache;
import org.infinispan.context.Flag;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.transaction.LockingMode;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="replication.FlagsReplicationTest")
public class FlagsReplicationTest
extends BaseDistFunctionalTest {
    static final String TEST_NAME = "replication.FlagsReplicationTest";
    static final String DATA_PROVIDER = "replication.FlagsReplicationTest.dataprovider";
    private ExecutorService threadPool;
    private final Integer one = 1;
    private final String key = "replication.FlagsReplicationTest";

    public FlagsReplicationTest() {
        this.tx = true;
        this.cacheName = TEST_NAME;
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
        this.lockingMode = LockingMode.PESSIMISTIC;
        this.lockTimeout = 1;
    }

    @DataProvider(name="replication.FlagsReplicationTest.dataprovider")
    public Object[][] createTestConfigurations() {
        return new Object[][]{{true, true}, {false, false}, {false, true}, {true, false}};
    }

    @Test(dataProvider="replication.FlagsReplicationTest.dataprovider")
    public void testScenario(boolean cache1IsOwner, boolean cache2IsOwner) throws Throwable {
        this.log.tracef("Start cache1IsOwner = %s, cache2IsOwner %s", (Object)cache1IsOwner, (Object)cache2IsOwner);
        AdvancedCache cache1 = (cache1IsOwner ? this.getFirstOwner(TEST_NAME) : this.getFirstNonOwner(TEST_NAME)).getAdvancedCache();
        AdvancedCache cache2 = (cache2IsOwner ? this.getFirstOwner(TEST_NAME) : this.getFirstNonOwner(TEST_NAME)).getAdvancedCache();
        assert (null == cache1.put((Object)TEST_NAME, (Object)this.one));
        this.haveSecondaryThreadTakeLock(cache2);
        cache1.getTransactionManager().begin();
        boolean locked = cache1.withFlags(new Flag[]{Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.FAIL_SILENTLY}).lock(new Object[]{TEST_NAME});
        assert (!locked);
        Object removed = cache1.withFlags(new Flag[]{Flag.SKIP_LOCKING}).remove((Object)TEST_NAME);
        assert (this.one.equals(removed));
        this.haveSecondaryThreadReleaseLock(cache2);
        cache1.getTransactionManager().commit();
        assert (null == cache2.get((Object)TEST_NAME));
        this.log.tracef("End cache1IsOwner = %s, cache2IsOwner %s", (Object)cache1IsOwner, (Object)cache2IsOwner);
    }

    private void haveSecondaryThreadTakeLock(AdvancedCache viaCache) throws InterruptedException, ExecutionException {
        AtomicBoolean noerrors = new AtomicBoolean(true);
        Future<?> submit = this.threadPool.submit(new LockingThread(viaCache, noerrors));
        submit.get();
        assert (noerrors.get());
    }

    private void haveSecondaryThreadReleaseLock(AdvancedCache viaCache) throws InterruptedException, ExecutionException {
        AtomicBoolean noerrors = new AtomicBoolean(true);
        Future<?> submit = this.threadPool.submit(new CommitThread(viaCache, noerrors));
        submit.get();
        assert (noerrors.get());
    }

    @BeforeClass(alwaysRun=true)
    protected void startThreadPool() {
        this.threadPool = Executors.newFixedThreadPool(1);
    }

    @AfterClass(alwaysRun=true)
    protected void stopThreadPool() {
        this.threadPool.shutdownNow();
    }

    private static class CommitThread
    implements Runnable {
        private final AdvancedCache cache;
        private final AtomicBoolean allok;

        CommitThread(AdvancedCache cache, AtomicBoolean allok) {
            this.cache = cache;
            this.allok = allok;
        }

        @Override
        public void run() {
            try {
                this.cache.getTransactionManager().commit();
            }
            catch (Throwable e) {
                this.allok.set(false);
            }
        }
    }

    private class LockingThread
    implements Runnable {
        private final AdvancedCache cache;
        private final AtomicBoolean allok;

        LockingThread(AdvancedCache cache, AtomicBoolean allok) {
            this.cache = cache;
            this.allok = allok;
        }

        @Override
        public void run() {
            try {
                FlagsReplicationTest.this.log.trace((Object)"About to try to acquire a lock.");
                this.cache.getTransactionManager().begin();
                if (!this.cache.lock(new Object[]{FlagsReplicationTest.TEST_NAME})) {
                    this.allok.set(false);
                    FlagsReplicationTest.this.log.trace((Object)"Could not acquire lock");
                }
            }
            catch (Throwable e) {
                FlagsReplicationTest.this.log.trace((Object)"Error", e);
                this.allok.set(false);
            }
        }
    }
}

