/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.replication;

import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.Cache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.config.Configuration;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.FutureListener;
import org.infinispan.util.concurrent.NotifyingFutureImpl;
import org.infinispan.util.concurrent.NotifyingNotifiableFuture;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="replication.InvokeRemotelyInFutureTest")
public class InvokeRemotelyInFutureTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration c = InvokeRemotelyInFutureTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC, true);
        this.createClusteredCaches(2, "futureRepl", c);
    }

    public void testInvokeRemotelyInFutureWithListener() throws Exception {
        Cache cache1 = this.cache(0, "futureRepl");
        final AtomicBoolean futureDoneOk = new AtomicBoolean();
        NotifyingFutureImpl f = new NotifyingFutureImpl((Object)new Integer(2));
        f.attachListener((FutureListener)new FutureListener<Object>(){

            public void futureDone(Future<Object> future) {
                try {
                    future.get();
                    futureDoneOk.set(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        CommandsFactory cf = (CommandsFactory)cache1.getAdvancedCache().getComponentRegistry().getComponent(CommandsFactory.class);
        cache1.getAdvancedCache().getRpcManager().invokeRemotelyInFuture(null, (ReplicableCommand)cf.buildPutKeyValueCommand((Object)"k", (Object)"v", -1L, -1L, null), (NotifyingNotifiableFuture)f);
        TestingUtil.sleepThread(2000L);
        assert (futureDoneOk.get());
    }
}

