/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.io.File;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.infinispan.Cache;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.file.FileCacheStoreConfig;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.statetransfer.StateTransferFunctionalTest;
import org.infinispan.statetransfer.StateTransferTestingUtil;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.StateTransferFileCacheLoaderFunctionalTest")
public class StateTransferFileCacheLoaderFunctionalTest
extends MultipleCacheManagersTest {
    static final Log log = LogFactory.getLog(StateTransferFileCacheLoaderFunctionalTest.class);
    static String cacheName = "nbst-with-file-loader";
    volatile int testCount = 0;
    ThreadLocal<Boolean> sharedCacheLoader = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    String tmpDirectory1;
    String tmpDirectory2;
    String tmpDirectory3;
    String tmpDirectory4;
    Configuration config;

    @BeforeTest
    @Parameters(value={"basedir"})
    protected void setUpTempDir(@Optional(value="/tmp") String basedir) {
        this.tmpDirectory1 = basedir + File.separator + TestingUtil.TEST_PATH + File.separator + "1" + File.separator + this.getClass().getSimpleName();
        this.tmpDirectory2 = basedir + File.separator + TestingUtil.TEST_PATH + File.separator + "2" + File.separator + this.getClass().getSimpleName();
        this.tmpDirectory3 = basedir + File.separator + TestingUtil.TEST_PATH + File.separator + "3" + File.separator + this.getClass().getSimpleName();
        this.tmpDirectory4 = basedir + File.separator + TestingUtil.TEST_PATH + File.separator + "4" + File.separator + this.getClass().getSimpleName();
    }

    @AfterMethod(alwaysRun=true)
    protected void clearTempDir() {
        TestingUtil.recursiveFileRemove(this.tmpDirectory1);
        new File(this.tmpDirectory1).mkdirs();
        TestingUtil.recursiveFileRemove(this.tmpDirectory2);
        new File(this.tmpDirectory2).mkdirs();
        TestingUtil.recursiveFileRemove(this.tmpDirectory3);
        new File(this.tmpDirectory3).mkdirs();
        TestingUtil.recursiveFileRemove(this.tmpDirectory4);
        new File(this.tmpDirectory4).mkdirs();
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.config = StateTransferFileCacheLoaderFunctionalTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC, true);
        this.config.setSyncReplTimeout(30000L);
        this.config.setFetchInMemoryState(true);
        this.config.setUseLockStriping(false);
    }

    protected CacheContainer createCacheManager(String tmpDirectory) {
        FileCacheStoreConfig cfg = new FileCacheStoreConfig();
        cfg.setLocation(tmpDirectory);
        cfg.setPurgeSynchronously(Boolean.valueOf(true));
        cfg.setFetchPersistentState(Boolean.valueOf(true));
        CacheLoaderManagerConfig clmc = new CacheLoaderManagerConfig();
        clmc.addCacheLoaderConfig((CacheLoaderConfig)cfg);
        clmc.setShared(this.sharedCacheLoader.get());
        this.config.setCacheLoaderManagerConfig(clmc);
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager();
        cm.defineConfiguration(cacheName, this.config.clone());
        return cm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSharedLoader() throws Exception {
        CacheContainer cm1 = null;
        CacheContainer cm2 = null;
        try {
            this.sharedCacheLoader.set(true);
            cm1 = this.createCacheManager(this.tmpDirectory1);
            Cache c1 = cm1.getCache(cacheName);
            StateTransferTestingUtil.verifyNoDataOnLoader((Cache<Object, Object>)c1);
            StateTransferTestingUtil.verifyNoData((Cache<Object, Object>)c1);
            StateTransferTestingUtil.writeInitialData((Cache<Object, Object>)c1);
            cm2 = this.createCacheManager(this.tmpDirectory2);
            Cache c2 = cm2.getCache(cacheName);
            TestingUtil.blockUntilViewsReceived(60000L, c1, c2);
            StateTransferTestingUtil.verifyInitialDataOnLoader((Cache<Object, Object>)c1);
            StateTransferTestingUtil.verifyInitialData((Cache<Object, Object>)c1);
            StateTransferTestingUtil.verifyNoDataOnLoader((Cache<Object, Object>)c2);
            StateTransferTestingUtil.verifyNoData((Cache<Object, Object>)c2);
        }
        finally {
            if (cm1 != null) {
                cm1.stop();
            }
            if (cm2 != null) {
                cm2.stop();
            }
            this.sharedCacheLoader.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInitialStateTransfer() throws Exception {
        ++this.testCount;
        log.info((Object)("testInitialStateTransfer start - " + this.testCount));
        CacheContainer cm1 = null;
        CacheContainer cm2 = null;
        try {
            cm1 = this.createCacheManager(this.tmpDirectory1);
            Cache cache1 = cm1.getCache(cacheName);
            StateTransferTestingUtil.writeInitialData((Cache<Object, Object>)cache1);
            cm2 = this.createCacheManager(this.tmpDirectory2);
            Cache cache2 = cm2.getCache(cacheName);
            TestingUtil.blockUntilViewsReceived(60000L, cache1, cache2);
            StateTransferTestingUtil.verifyInitialData((Cache<Object, Object>)cache2);
            log.info((Object)("testInitialStateTransfer end - " + this.testCount));
        }
        finally {
            if (cm1 != null) {
                cm1.stop();
            }
            if (cm2 != null) {
                cm2.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInitialStateTransferInDifferentThread(Method m) throws Exception {
        ++this.testCount;
        log.info((Object)(m.getName() + " start - " + this.testCount));
        CacheContainer cm1 = null;
        CacheContainer cm2 = null;
        CacheContainer cm30 = null;
        try {
            CacheContainer cm3;
            Cache cache1 = null;
            Cache cache2 = null;
            Cache cache3 = null;
            cm1 = this.createCacheManager(this.tmpDirectory1);
            cache1 = cm1.getCache(cacheName);
            StateTransferTestingUtil.writeInitialData((Cache<Object, Object>)cache1);
            cm2 = this.createCacheManager(this.tmpDirectory2);
            cache2 = cm2.getCache(cacheName);
            cache1.put((Object)"delay", (Object)new StateTransferFunctionalTest.DelayTransfer());
            TestingUtil.blockUntilViewsReceived(60000L, cache1, cache2);
            StateTransferTestingUtil.verifyInitialData((Cache<Object, Object>)cache2);
            cm30 = cm3 = this.createCacheManager(this.tmpDirectory3);
            Future<Void> f1 = Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, "CacheStarter-Cache3");
                }
            }).submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    cm3.getCache(cacheName);
                    return null;
                }
            });
            f1.get();
            cache3 = cm3.getCache(cacheName);
            TestingUtil.blockUntilViewsReceived(120000L, cache1, cache2, cache3);
            StateTransferTestingUtil.verifyInitialData((Cache<Object, Object>)cache3);
            log.info((Object)("testConcurrentStateTransfer end - " + this.testCount));
        }
        finally {
            if (cm1 != null) {
                cm1.stop();
            }
            if (cm2 != null) {
                cm2.stop();
            }
            if (cm30 != null) {
                cm30.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentStateTransfer() throws Exception {
        ++this.testCount;
        log.info((Object)("testConcurrentStateTransfer start - " + this.testCount));
        CacheContainer cm1 = null;
        CacheContainer cm2 = null;
        CacheContainer cm30 = null;
        CacheContainer cm40 = null;
        try {
            Cache cache1 = null;
            Cache cache2 = null;
            Cache cache3 = null;
            Cache cache4 = null;
            cm1 = this.createCacheManager(this.tmpDirectory1);
            cache1 = cm1.getCache(cacheName);
            StateTransferTestingUtil.writeInitialData((Cache<Object, Object>)cache1);
            cm2 = this.createCacheManager(this.tmpDirectory2);
            cache2 = cm2.getCache(cacheName);
            cache1.put((Object)"delay", (Object)new StateTransferFunctionalTest.DelayTransfer());
            TestingUtil.blockUntilViewsReceived(60000L, cache1, cache2);
            StateTransferTestingUtil.verifyInitialData((Cache<Object, Object>)cache2);
            final CacheContainer cm3 = this.createCacheManager(this.tmpDirectory3);
            final CacheContainer cm4 = this.createCacheManager(this.tmpDirectory4);
            cm30 = cm3;
            cm40 = cm4;
            Future<Void> f1 = Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, "CacheStarter-Cache3");
                }
            }).submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    cm3.getCache(cacheName);
                    return null;
                }
            });
            Future<Void> f2 = Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, "CacheStarter-Cache4");
                }
            }).submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    cm4.getCache(cacheName);
                    return null;
                }
            });
            f1.get();
            f2.get();
            cache3 = cm3.getCache(cacheName);
            cache4 = cm4.getCache(cacheName);
            TestingUtil.blockUntilViewsReceived(120000L, cache1, cache2, cache3, cache4);
            StateTransferTestingUtil.verifyInitialData((Cache<Object, Object>)cache3);
            StateTransferTestingUtil.verifyInitialData((Cache<Object, Object>)cache4);
            log.info((Object)("testConcurrentStateTransfer end - " + this.testCount));
        }
        finally {
            if (cm1 != null) {
                cm1.stop();
            }
            if (cm2 != null) {
                cm2.stop();
            }
            if (cm30 != null) {
                cm30.stop();
            }
            if (cm40 != null) {
                cm40.stop();
            }
        }
    }
}

