/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stress;

import java.util.Random;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.container.DataContainer;
import org.infinispan.container.DefaultDataContainer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(testName="stress.DataContainerStressTest", groups={"stress"}, enabled=false, description="Disabled by default, designed to be run manually.")
public class DataContainerStressTest {
    volatile CountDownLatch latch;
    final int RUN_TIME_MILLIS = 45000;
    final int WARMUP_TIME_MILLIS = 10000;
    final int num_loops = 10000;
    final int warmup_num_loops = 10000;
    boolean use_time = true;
    final int NUM_KEYS = 100;
    private static final Log log = LogFactory.getLog(DataContainerStressTest.class);
    private static final Random R = new Random();

    public void testSimpleDataContainer() throws InterruptedException {
        this.doTest(DefaultDataContainer.unBoundedDataContainer((int)5000));
    }

    private void doTest(DataContainer dc) throws InterruptedException {
        this.doTest(dc, true);
        this.doTest(dc, false);
    }

    private void doTest(final DataContainer dc, boolean warmup) throws InterruptedException {
        Thread[] threads;
        this.latch = new CountDownLatch(1);
        String key = "key";
        final ConcurrentSkipListMap perf = new ConcurrentSkipListMap();
        final AtomicBoolean run = new AtomicBoolean(true);
        final int actual_num_loops = warmup ? 10000 : 10000;
        Thread getter = new Thread(){

            @Override
            public void run() {
                int runs;
                DataContainerStressTest.this.waitForStart();
                long start = System.nanoTime();
                for (runs = 0; DataContainerStressTest.this.use_time && run.get() || runs < actual_num_loops; ++runs) {
                    if (runs % 100000 == 0) {
                        log.info((Object)("GET run # " + runs));
                    }
                    dc.get((Object)("key" + R.nextInt(100)));
                }
                perf.put("GET", DataContainerStressTest.this.opsPerMS(System.nanoTime() - start, runs));
            }
        };
        Thread putter = new Thread(){

            @Override
            public void run() {
                int runs;
                DataContainerStressTest.this.waitForStart();
                long start = System.nanoTime();
                for (runs = 0; DataContainerStressTest.this.use_time && run.get() || runs < actual_num_loops; ++runs) {
                    if (runs % 100000 == 0) {
                        log.info((Object)("PUT run # " + runs));
                    }
                    dc.put((Object)("key" + R.nextInt(100)), (Object)"value", null, -1L, -1L);
                }
                perf.put("PUT", DataContainerStressTest.this.opsPerMS(System.nanoTime() - start, runs));
            }
        };
        Thread remover = new Thread(){

            @Override
            public void run() {
                int runs;
                DataContainerStressTest.this.waitForStart();
                long start = System.nanoTime();
                for (runs = 0; DataContainerStressTest.this.use_time && run.get() || runs < actual_num_loops; ++runs) {
                    if (runs % 100000 == 0) {
                        log.info((Object)("REM run # " + runs));
                    }
                    dc.remove((Object)("key" + R.nextInt(100)));
                }
                perf.put("REM", DataContainerStressTest.this.opsPerMS(System.nanoTime() - start, runs));
            }
        };
        for (Thread t : threads = new Thread[]{getter, putter, remover}) {
            t.start();
        }
        this.latch.countDown();
        Thread.sleep(warmup ? 10000L : 45000L);
        run.set(false);
        for (Thread t : threads) {
            t.join();
        }
        if (!warmup) {
            log.warnf("%s: Performance: %s", (Object)dc.getClass().getSimpleName(), perf);
        }
    }

    private void waitForStart() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private String opsPerMS(long nanos, int ops) {
        long totalMillis = TimeUnit.NANOSECONDS.toMillis(nanos);
        if (totalMillis > 0L) {
            return (long)ops / totalMillis + " ops/ms";
        }
        return "NAN ops/ms";
    }
}

