/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import org.infinispan.commands.VisitableCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.interceptors.locking.PessimisticLockingInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.transaction.LockingMode;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.ExceptionDuringGetTest")
public class ExceptionDuringGetTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration dcc = ExceptionDuringGetTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC, true);
        dcc.fluent().transaction().lockingMode(LockingMode.PESSIMISTIC);
        this.createCluster(dcc, 2);
        this.waitForClusterToForm();
        this.cache(0).put((Object)"k", (Object)"v");
        assert (this.cache(1).get((Object)"k").equals("v"));
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="Induced!")
    public void testExceptionDuringGet() {
        this.advancedCache(0).addInterceptorAfter(new CommandInterceptor(){

            protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
                throw new RuntimeException("Induced!");
            }
        }, PessimisticLockingInterceptor.class);
        this.cache(0).get((Object)"k");
        assert (false);
    }
}

