/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.dld;

import javax.transaction.RollbackException;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.PerCacheExecutorThread;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.locks.DeadlockDetectedException;
import org.infinispan.util.concurrent.locks.DeadlockDetectingLockManager;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.dld.LocalDeadlockDetectionTest")
public class LocalDeadlockDetectionTest
extends SingleCacheManagerTest {
    private PerCacheExecutorThread t1;
    private PerCacheExecutorThread t2;
    private DeadlockDetectingLockManager lockManager;
    private Object response1;
    private Object response2;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createLocalCacheManager(false);
        Configuration configuration = this.createConfig();
        configuration.fluent().transaction().lockingMode(LockingMode.PESSIMISTIC);
        this.cacheManager.defineConfiguration("test", configuration);
        this.cache = this.cacheManager.getCache("test");
        this.lockManager = (DeadlockDetectingLockManager)TestingUtil.extractLockManager(this.cache);
        return this.cacheManager;
    }

    protected Configuration createConfig() {
        Configuration configuration = this.getDefaultStandaloneConfig(true);
        configuration.setEnableDeadlockDetection(true);
        configuration.setUseLockStriping(false);
        configuration.setExposeJmxStatistics(true);
        return configuration;
    }

    @BeforeMethod
    public void startExecutors() {
        this.t1 = new PerCacheExecutorThread((Cache<Object, Object>)this.cache, 0);
        this.t2 = new PerCacheExecutorThread((Cache<Object, Object>)this.cache, 1);
        this.lockManager.resetStatistics();
    }

    @AfterMethod
    public void stopExecutors() {
        this.t1.stopThread();
        this.t2.stopThread();
    }

    public void testDldPutAndPut() {
        this.testLocalVsLocalTxDeadlock(PerCacheExecutorThread.Operations.PUT_KEY_VALUE, PerCacheExecutorThread.Operations.PUT_KEY_VALUE);
        if (this.response1 instanceof Exception) {
            Assert.assertEquals((Object)"value_1_t2", (Object)this.cache.get((Object)"k1"));
            Assert.assertEquals((Object)"value_2_t2", (Object)this.cache.get((Object)"k2"));
        } else {
            Assert.assertEquals((Object)"value_1_t1", (Object)this.cache.get((Object)"k1"));
            Assert.assertEquals((Object)"value_2_t1", (Object)this.cache.get((Object)"k2"));
        }
    }

    public void testDldPutAndRemove() {
        this.testLocalVsLocalTxDeadlock(PerCacheExecutorThread.Operations.PUT_KEY_VALUE, PerCacheExecutorThread.Operations.REMOVE_KEY);
        if (this.response1 instanceof Exception) {
            Assert.assertEquals((Object)this.cache.get((Object)"k1"), null);
            Assert.assertEquals((Object)"value_2_t2", (Object)this.cache.get((Object)"k2"));
        } else {
            Assert.assertEquals((Object)"value_1_t1", (Object)this.cache.get((Object)"k1"));
            Assert.assertEquals(null, (Object)this.cache.get((Object)"k2"));
        }
    }

    public void testDldRemoveAndPut() {
        this.testLocalVsLocalTxDeadlock(PerCacheExecutorThread.Operations.REMOVE_KEY, PerCacheExecutorThread.Operations.PUT_KEY_VALUE);
        if (this.response1 instanceof Exception) {
            System.out.println("t1 failure");
            Assert.assertEquals((Object)this.cache.get((Object)"k1"), (Object)"value_1_t2");
            Assert.assertEquals((Object)this.cache.get((Object)"k2"), null);
        } else {
            System.out.println("t2 failure");
            Assert.assertEquals((Object)this.cache.get((Object)"k1"), null);
            Assert.assertEquals((Object)this.cache.get((Object)"k2"), (Object)"value_2_t1");
        }
    }

    public void testDldRemoveAndRemove() {
        this.testLocalVsLocalTxDeadlock(PerCacheExecutorThread.Operations.REMOVE_KEY, PerCacheExecutorThread.Operations.REMOVE_KEY);
        if (this.response1 instanceof Exception) {
            System.out.println("t1 failure");
            Assert.assertEquals((Object)this.cache.get((Object)"k1"), null);
            Assert.assertEquals((Object)this.cache.get((Object)"k2"), null);
        } else {
            System.out.println("t2 failure");
            Assert.assertEquals((Object)this.cache.get((Object)"k1"), null);
            Assert.assertEquals((Object)this.cache.get((Object)"k2"), null);
        }
    }

    public void testDldPutAndReplace() {
        this.cache.put((Object)"k1", (Object)"initial_1");
        this.cache.put((Object)"k2", (Object)"initial_2");
        this.testLocalVsLocalTxDeadlock(PerCacheExecutorThread.Operations.PUT_KEY_VALUE, PerCacheExecutorThread.Operations.REPLACE_KEY_VALUE);
        if (this.response1 instanceof Exception) {
            System.out.println("t1 failure");
            Assert.assertEquals((Object)this.cache.get((Object)"k1"), (Object)"value_1_t2");
            Assert.assertEquals((Object)this.cache.get((Object)"k2"), (Object)"value_2_t2");
        } else {
            System.out.println("t2 failure");
            Assert.assertEquals((Object)this.cache.get((Object)"k1"), (Object)"value_1_t1");
            Assert.assertEquals((Object)this.cache.get((Object)"k2"), (Object)"value_2_t1");
        }
    }

    public void testDldReplaceAndPut() {
        this.cache.put((Object)"k1", (Object)"initial_1");
        this.cache.put((Object)"k2", (Object)"initial_2");
        this.testLocalVsLocalTxDeadlock(PerCacheExecutorThread.Operations.REPLACE_KEY_VALUE, PerCacheExecutorThread.Operations.PUT_KEY_VALUE);
        if (this.response1 instanceof Exception) {
            System.out.println("t1 failure");
            Assert.assertEquals((Object)this.cache.get((Object)"k1"), (Object)"value_1_t2");
            Assert.assertEquals((Object)this.cache.get((Object)"k2"), (Object)"value_2_t2");
        } else {
            System.out.println("t2 failure");
            Assert.assertEquals((Object)this.cache.get((Object)"k1"), (Object)"value_1_t1");
            Assert.assertEquals((Object)this.cache.get((Object)"k2"), (Object)"value_2_t1");
        }
    }

    private void testLocalVsLocalTxDeadlock(PerCacheExecutorThread.Operations firstOperation, PerCacheExecutorThread.Operations secondOperation) {
        assert (PerCacheExecutorThread.OperationsResult.BEGIN_TX_OK == this.t1.execute(PerCacheExecutorThread.Operations.BEGIN_TX));
        assert (PerCacheExecutorThread.OperationsResult.BEGIN_TX_OK == this.t2.execute(PerCacheExecutorThread.Operations.BEGIN_TX));
        this.t1.setKeyValue("k1", "value_1_t1");
        this.t2.setKeyValue("k2", "value_2_t2");
        Assert.assertEquals((Object)this.t1.execute(firstOperation), (Object)((Object)firstOperation.getCorrespondingOkResult()));
        Assert.assertEquals((Object)this.t2.execute(firstOperation), (Object)((Object)firstOperation.getCorrespondingOkResult()));
        assert (this.lockManager.isLocked((Object)"k1"));
        assert (this.lockManager.isLocked((Object)"k2"));
        this.t1.setKeyValue("k2", "value_2_t1");
        this.t2.setKeyValue("k1", "value_1_t2");
        this.t1.executeNoResponse(secondOperation);
        this.t2.executeNoResponse(secondOperation);
        this.response1 = this.t1.waitForResponse();
        this.response2 = this.t2.waitForResponse();
        assert (this.xor(this.response1 instanceof DeadlockDetectedException, this.response2 instanceof DeadlockDetectedException)) : "expected one and only one exception: " + this.response1 + ", " + this.response2;
        assert (this.xor(this.response1 == secondOperation.getCorrespondingOkResult(), this.response2 == secondOperation.getCorrespondingOkResult())) : "expected one and only one exception: " + this.response1 + ", " + this.response2;
        assert (this.lockManager.isLocked((Object)"k1"));
        assert (this.lockManager.isLocked((Object)"k2"));
        assert (this.lockManager.getOwner((Object)"k1") == this.lockManager.getOwner((Object)"k2"));
        if (this.response1 instanceof Exception) {
            Assert.assertEquals((Object)((Object)PerCacheExecutorThread.OperationsResult.COMMIT_TX_OK), (Object)this.t2.execute(PerCacheExecutorThread.Operations.COMMIT_TX));
            assert (this.t1.execute(PerCacheExecutorThread.Operations.COMMIT_TX) instanceof RollbackException);
        } else {
            assert (PerCacheExecutorThread.OperationsResult.COMMIT_TX_OK == this.t1.execute(PerCacheExecutorThread.Operations.COMMIT_TX));
            assert (this.t2.execute(PerCacheExecutorThread.Operations.COMMIT_TX) instanceof RollbackException);
        }
        assert (this.lockManager.getNumberOfLocksHeld() == 0);
        Assert.assertEquals((long)this.lockManager.getDetectedLocalDeadlocks(), (long)1L);
    }
}

