/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.locking;

import javax.transaction.Transaction;
import org.infinispan.config.Configuration;
import org.infinispan.transaction.LockingMode;
import org.infinispan.tx.locking.AbstractClusteredTxTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.locking.OptimisticReplTxTest")
public class OptimisticReplTxTest
extends AbstractClusteredTxTest {
    Configuration.CacheMode cacheMode = Configuration.CacheMode.REPL_SYNC;

    public void testTxProgress() throws Exception {
        this.tm(0).begin();
        this.cache(0).put(this.k, (Object)"v1");
        Transaction tx1 = this.tm(0).suspend();
        this.tm(0).begin();
        this.cache(0).put(this.k, (Object)"v2");
        this.tm(0).commit();
        assert (this.cache(0).get((Object)"k").equals("v2"));
        assert (this.cache(1).get((Object)"k").equals("v2"));
        this.tm(0).resume(tx1);
        this.tm(0).commit();
        assert (this.cache(0).get((Object)"k").equals("v1"));
        assert (this.cache(1).get((Object)"k").equals("v1"));
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.k = "k";
        Configuration conf = OptimisticReplTxTest.getDefaultClusteredConfig(this.cacheMode, true);
        conf.fluent().transaction().lockingMode(LockingMode.OPTIMISTIC);
        this.createCluster(conf, 2);
        this.waitForClusterToForm();
    }

    @Override
    protected void assertLocking() {
        Assert.assertFalse((boolean)this.lockManager(0).isLocked(this.k));
        Assert.assertFalse((boolean)this.lockManager(1).isLocked(this.k));
        this.prepare();
        Assert.assertTrue((boolean)this.lockManager(0).isLocked(this.k));
        Assert.assertTrue((boolean)this.lockManager(1).isLocked(this.k));
        this.commit();
        Assert.assertFalse((boolean)this.lockManager(0).isLocked(this.k));
        Assert.assertFalse((boolean)this.lockManager(1).isLocked(this.k));
    }
}

