/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.lockreordering;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CyclicBarrier;
import org.infinispan.Cache;
import org.infinispan.commons.hash.MurmurHash2;
import org.infinispan.config.Configuration;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.tx.lockreordering.StresserThread;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.lockreordering.LocalLockReorderingTest")
public class LocalLockReorderingTest
extends SingleCacheManagerTest {
    private List<Integer> keys;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        Configuration c = this.getDefaultStandaloneConfig(true);
        c.fluent().transaction().cacheStopTimeout(Integer.valueOf(1));
        this.keys = LocalLockReorderingTest.generateKeys();
        return new DefaultCacheManager(c);
    }

    public void testWithPut(Method m) throws Exception {
        LocalLockReorderingTest.runTest(StresserThread.PUT_PERFORMER, this.cache, this.cache, this.keys, this.getThreadName(m));
    }

    public void testWithRemove(Method m) throws InterruptedException {
        LocalLockReorderingTest.runTest(StresserThread.REMOVE_PERFORMER, this.cache, this.cache, this.keys, this.getThreadName(m));
    }

    public void testWithPutAll(Method m) throws InterruptedException {
        LocalLockReorderingTest.runTest(StresserThread.PUT_ALL_PERFORMER, this.cache, this.cache, this.keys, this.getThreadName(m));
    }

    public void testMixed(Method m) throws InterruptedException {
        LocalLockReorderingTest.runTest(StresserThread.MIXED_OPS_PERFORMER, this.cache, this.cache, this.keys, this.getThreadName(m));
    }

    static void runTest(StresserThread.OperationsPerformer ops, Cache c1, Cache c2, List keys, String threadNamePrefix) throws InterruptedException {
        CyclicBarrier beforeCommit = new CyclicBarrier(2);
        StresserThread st1 = new StresserThread(c1, keys, "t1", ops, beforeCommit, threadNamePrefix + "-1");
        ArrayList reversedKeys = new ArrayList(keys);
        Collections.reverse(reversedKeys);
        StresserThread st2 = new StresserThread(c2, reversedKeys, "t2", ops, beforeCommit, threadNamePrefix + "-2");
        st1.start();
        st2.start();
        st1.join();
        st2.join();
        assert (!st1.isError());
        assert (!st2.isError());
    }

    static List<Integer> generateKeys() {
        MurmurHash2 hashFunction = new MurmurHash2();
        ArrayList<Integer> keys = new ArrayList<Integer>(2);
        int count = 0;
        keys.add(count);
        while (keys.size() < 2) {
            int hash;
            if (keys.contains(hash = hashFunction.hash(++count))) continue;
            keys.add(count);
        }
        return keys;
    }

    private String getThreadName(Method m) {
        return this.getClass().getSimpleName() + "." + m.getName();
    }
}

