/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.recovery.admin;

import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import junit.framework.Assert;
import org.infinispan.config.Configuration;
import org.infinispan.transaction.RemoteTransaction;
import org.infinispan.transaction.tm.DummyTransaction;
import org.infinispan.transaction.xa.recovery.RecoverableTransactionIdentifier;
import org.infinispan.transaction.xa.recovery.RecoveryAwareTransactionTable;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.tx.recovery.PostCommitRecoveryStateTest;
import org.infinispan.tx.recovery.RecoveryTestUtil;
import org.infinispan.tx.recovery.admin.AbstractRecoveryTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.recovery.admin.ForgetTest")
public class ForgetTest
extends AbstractRecoveryTest {
    private PostCommitRecoveryStateTest.RecoveryManagerDelegate recoveryManager;
    private DummyTransaction tx;

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration configuration = this.defaultRecoveryConfig();
        this.createCluster(configuration, 2);
        this.waitForClusterToForm();
        RecoveryAwareTransactionTable txTable = this.tt(0);
        this.recoveryManager = new PostCommitRecoveryStateTest.RecoveryManagerDelegate(txTable.getRecoveryManager());
        txTable.setRecoveryManager((RecoveryManager)this.recoveryManager);
    }

    @BeforeMethod
    public void runTx() throws XAException {
        this.tx = RecoveryTestUtil.beginAndSuspendTx(this.cache(0));
        RecoveryTestUtil.prepareTransaction(this.tx);
        Assert.assertEquals((int)this.recoveryManager(0).getPreparedTransactionsFromCluster().all().length, (int)1);
        Assert.assertEquals((int)this.tt(0).getLocalPreparedXids().size(), (int)1);
        Assert.assertEquals((int)this.tt(1).getRemoteTxCount(), (int)1);
        RecoveryTestUtil.commitTransaction(this.tx);
        Assert.assertEquals((int)this.tt(1).getRemoteTxCount(), (int)1);
    }

    public void testInternalIdOnSameNode() throws Exception {
        Xid xid = this.tx.getXid();
        String result = this.recoveryOps(0).forget(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        System.out.println("result = " + result);
        Assert.assertEquals((int)this.tt(1).getRemoteTxCount(), (int)0);
    }

    public void testForgetXidOnSameNode() throws Exception {
        this.forgetWithXid(0);
    }

    public void testForgetXidOnOtherNode() throws Exception {
        this.forgetWithXid(1);
    }

    public void testForgetInternalIdOnSameNode() throws Exception {
        this.forgetWithInternalId(0);
    }

    public void testForgetInternalIdOnOtherNode() throws Exception {
        this.forgetWithInternalId(1);
    }

    protected void forgetWithInternalId(int cacheIndex) {
        long internalId = -1L;
        for (RemoteTransaction rt : this.tt(1).getRemoteTransactions()) {
            RecoverableTransactionIdentifier a = (RecoverableTransactionIdentifier)rt.getGlobalTransaction();
            if (!a.getXid().equals(this.tx.getXid())) continue;
            internalId = a.getInternalId();
        }
        if (internalId == -1L) {
            throw new IllegalStateException();
        }
        this.log.tracef("About to forget... %s", (Object)internalId);
        this.recoveryOps(cacheIndex).forget(internalId);
        Assert.assertEquals((int)this.tt(0).getRemoteTxCount(), (int)0);
        Assert.assertEquals((int)this.tt(1).getRemoteTxCount(), (int)0);
    }

    private void forgetWithXid(int nodeIndex) {
        Xid xid = this.tx.getXid();
        this.recoveryOps(nodeIndex).forget(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        Assert.assertEquals((int)this.tt(1).getRemoteTxCount(), (int)0);
    }
}

