/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.synchronisation;

import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.synchronization.NoXaConfigTest")
public class NoXaConfigTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return new DefaultCacheManager("configs/no-xa-config.xml");
    }

    public void testConfig() {
        assert (this.cacheManager.getCache("syncEnabled").getConfiguration().isUseSynchronizationForTransactions());
        assert (!this.cacheManager.getCache("notSpecified").getConfiguration().isUseSynchronizationForTransactions());
        try {
            this.cacheManager.getCache("syncAndRecovery");
            assert (false);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    public void testConfigOverride() {
        Configuration configuration = this.getDefaultStandaloneConfig(true);
        configuration.fluent().transaction().useSynchronization(Boolean.valueOf(true));
        this.cacheManager.defineConfiguration("newCache", configuration);
        assert (this.cacheManager.getCache("newCache").getConfiguration().isUseSynchronizationForTransactions());
    }
}

