/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic;

import java.io.InputStream;
import org.infinispan.schematic.DocumentLibrary;
import org.infinispan.schematic.SchemaLibrary;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.Json;
import org.infinispan.schematic.internal.InMemoryDocumentLibrary;
import org.infinispan.schematic.internal.document.Paths;
import org.infinispan.schematic.internal.schema.Problems;
import org.infinispan.schematic.internal.schema.SchemaDocument;
import org.infinispan.schematic.internal.schema.SchemaDocumentCache;
import org.infinispan.schematic.internal.schema.ValidationResult;
import org.infinispan.schematic.internal.schema.Validator;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SchemaValidationTest {
    private static DocumentLibrary docs;
    private SchemaDocumentCache schemaDocs;
    private SchemaLibrary.Results results;

    @BeforeClass
    public static void beforeAll() throws Exception {
        docs = new InMemoryDocumentLibrary("tests");
        docs.put("http://json-schema.org/draft-03/schema#", Json.read((InputStream)SchemaValidationTest.resource("json/schema/draft-03/schema.json")));
        docs.put("json/spec-example-doc.json", Json.read((InputStream)SchemaValidationTest.resource("json/spec-example-doc.json")));
        docs.put("json/schema/spec-example.json", Json.read((InputStream)SchemaValidationTest.resource("json/schema/spec-example.json")));
        docs.put("json/sample-repo-config.json", Json.read((InputStream)SchemaValidationTest.resource("json/sample-repo-config.json")));
        docs.put("json/empty.json", Json.read((InputStream)SchemaValidationTest.resource("json/empty.json")));
        docs.put("json/schema/repository-config-schema.json", Json.read((InputStream)SchemaValidationTest.resource("json/schema/repository-config-schema.json")));
    }

    protected static InputStream resource(String resourcePath) {
        InputStream result = SchemaValidationTest.class.getClassLoader().getResourceAsStream(resourcePath);
        assert (result != null) : "Could not find resource \"" + resourcePath + "\"";
        return result;
    }

    @Before
    public void beforeEach() {
        this.schemaDocs = new SchemaDocumentCache(docs, null);
    }

    protected void assertNoProblems(SchemaLibrary.Results results) {
        if (results.hasProblems()) {
            System.out.println(results);
            assert (false);
        }
    }

    protected SchemaLibrary.Results validate(String documentUri, String schemaUri) {
        Document doc = docs.get(documentUri);
        ValidationResult problems = new ValidationResult();
        SchemaDocument schema = this.schemaDocs.get(schemaUri, (Problems)problems);
        if (schema != null) {
            schema.getValidator().validate(null, null, doc, Paths.rootPath(), (Problems)problems, (Validator.SchemaDocumentResolver)this.schemaDocs);
        }
        return problems;
    }

    @Test
    public void shouldBeAbleToValidateDocumentUsingSimpleSchemaDocument() throws Exception {
        this.results = this.validate("json/spec-example-doc.json", "json/schema/spec-example.json");
        this.assertNoProblems(this.results);
    }

    @Test
    public void shouldBeAbleToValidateSampleDocumentUsingSchemaDocument() throws Exception {
        this.results = this.validate("json/sample-repo-config.json", "json/schema/repository-config-schema.json");
        this.assertNoProblems(this.results);
    }

    @Test
    public void shouldNotBeAbleToValidateEmptyDocumentUsingSchemaDocument() throws Exception {
        this.results = this.validate("json/empty.json", "json/schema/repository-config-schema.json");
        assert (this.results.errorCount() == 1);
    }
}

