/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.security.acl.Group;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.Util;
import org.jboss.security.auth.spi.SecurityActions;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapUsersLoginModule
extends UsernamePasswordLoginModule {
    private static final String BIND_DN = "bindDN";
    private static final String BIND_CREDENTIAL = "bindCredential";
    private static final String BASE_CTX_DN = "baseCtxDN";
    private static final String BASE_FILTER_OPT = "baseFilter";
    private static final String SEARCH_TIME_LIMIT_OPT = "searchTimeLimit";
    private static final String SEARCH_SCOPE_OPT = "searchScope";
    private static final String DISTINGUISHED_NAME_ATTRIBUTE_OPT = "distinguishedNameAttribute";
    private static final String PARSE_USERNAME = "parseUsername";
    private static final String USERNAME_BEGIN_STRING = "usernameBeginString";
    private static final String USERNAME_END_STRING = "usernameEndString";
    private static final String ALLOW_EMPTY_PASSWORDS = "allowEmptyPasswords";
    protected String bindDN;
    protected String bindCredential;
    protected String baseDN;
    protected String baseFilter;
    protected int searchTimeLimit = 10000;
    protected int searchScope = 2;
    protected String distinguishedNameAttribute;
    protected boolean parseUsername;
    protected String usernameBeginString;
    protected String usernameEndString;
    protected boolean allowEmptyPasswords;

    @Override
    protected String getUsersPassword() throws LoginException {
        return "";
    }

    @Override
    protected Group[] getRoleSets() throws LoginException {
        return new Group[0];
    }

    @Override
    protected String getUsername() {
        String username = super.getUsername();
        if (this.parseUsername) {
            int beginIndex = 0;
            if (this.usernameBeginString != null && !this.usernameBeginString.equals("")) {
                beginIndex = username.indexOf(this.usernameBeginString) + this.usernameBeginString.length();
            }
            if (beginIndex == -1) {
                beginIndex = 0;
            }
            int endIndex = username.length();
            if (this.usernameEndString != null && !this.usernameEndString.equals("")) {
                endIndex = username.substring(beginIndex).indexOf(this.usernameEndString);
            }
            endIndex = endIndex == -1 ? username.length() : (endIndex += beginIndex);
            username = username.substring(beginIndex, endIndex);
        }
        return username;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        String scope;
        block12: {
            super.initialize(subject, callbackHandler, sharedState, options);
            this.trace = this.log.isTraceEnabled();
            this.bindDN = (String)options.get(BIND_DN);
            this.bindCredential = (String)options.get(BIND_CREDENTIAL);
            if (this.bindCredential != null && this.bindCredential.startsWith("{EXT}")) {
                try {
                    this.bindCredential = new String(Util.loadPassword(this.bindCredential));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("PB00019: Processing Failed:Unable to decode bindCredential", e);
                }
            }
            this.baseDN = (String)options.get(BASE_CTX_DN);
            this.baseFilter = (String)options.get(BASE_FILTER_OPT);
            String timeLimit = (String)options.get(SEARCH_TIME_LIMIT_OPT);
            if (timeLimit != null) {
                try {
                    this.searchTimeLimit = Integer.parseInt(timeLimit);
                }
                catch (NumberFormatException e) {
                    if (!this.trace) break block12;
                    this.log.trace((Object)("Failed to parse: " + timeLimit + ", using searchTimeLimit=" + this.searchTimeLimit), (Throwable)e);
                }
            }
        }
        if ("OBJECT_SCOPE".equalsIgnoreCase(scope = (String)options.get(SEARCH_SCOPE_OPT))) {
            this.searchScope = 0;
        } else if ("ONELEVEL_SCOPE".equalsIgnoreCase(scope)) {
            this.searchScope = 1;
        }
        if ("SUBTREE_SCOPE".equalsIgnoreCase(scope)) {
            this.searchScope = 2;
        }
        this.distinguishedNameAttribute = (String)options.get(DISTINGUISHED_NAME_ATTRIBUTE_OPT);
        if (this.distinguishedNameAttribute == null) {
            this.distinguishedNameAttribute = "distinguishedName";
        }
        this.allowEmptyPasswords = Boolean.valueOf((String)options.get(ALLOW_EMPTY_PASSWORDS));
        this.parseUsername = Boolean.valueOf((String)options.get(PARSE_USERNAME));
        if (this.parseUsername) {
            this.usernameBeginString = (String)options.get(USERNAME_BEGIN_STRING);
            this.usernameEndString = (String)options.get(USERNAME_END_STRING);
        }
    }

    @Override
    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        boolean isValid = false;
        if (inputPassword != null) {
            if (inputPassword.length() == 0 && !this.allowEmptyPasswords) {
                if (this.trace) {
                    this.log.trace((Object)"Rejecting empty password due to allowEmptyPasswords");
                }
                return false;
            }
            try {
                String username = this.getUsername();
                isValid = this.createLdapInitContext(username, inputPassword);
            }
            catch (Throwable e) {
                super.setValidateError(e);
            }
        }
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createLdapInitContext(String username, Object credential) throws Exception {
        InitialContext ctx = null;
        ClassLoader currentTCCL = SecurityActions.getContextClassLoader();
        try {
            if (currentTCCL != null) {
                SecurityActions.setContextClassLoader(null);
            }
            ctx = this.constructInitialLdapContext(this.bindDN, this.bindCredential);
            this.bindDNAuthentication((InitialLdapContext)ctx, username, credential, this.baseDN, this.baseFilter);
        }
        finally {
            if (ctx != null) {
                ctx.close();
            }
            if (currentTCCL != null) {
                SecurityActions.setContextClassLoader(currentTCCL);
            }
        }
        return true;
    }

    private InitialLdapContext constructInitialLdapContext(String dn, Object credential) throws NamingException {
        String authType;
        Properties env = new Properties();
        for (Map.Entry entry : this.options.entrySet()) {
            env.put(entry.getKey(), entry.getValue());
        }
        String factoryName = env.getProperty("java.naming.factory.initial");
        if (factoryName == null) {
            factoryName = "com.sun.jndi.ldap.LdapCtxFactory";
            env.setProperty("java.naming.factory.initial", factoryName);
        }
        if ((authType = env.getProperty("java.naming.security.authentication")) == null) {
            env.setProperty("java.naming.security.authentication", "simple");
        }
        String protocol = env.getProperty("java.naming.security.protocol");
        String providerURL = (String)this.options.get("java.naming.provider.url");
        if (providerURL == null) {
            providerURL = "ldap://localhost:" + (protocol != null && protocol.equals("ssl") ? "636" : "389");
        }
        env.setProperty("java.naming.provider.url", providerURL);
        if (dn != null) {
            env.setProperty("java.naming.security.principal", dn);
        }
        if (credential != null) {
            env.put("java.naming.security.credentials", credential);
        }
        this.traceLdapEnv(env);
        return new InitialLdapContext(env, null);
    }

    private void traceLdapEnv(Properties env) {
        if (this.trace) {
            Properties tmp = new Properties();
            tmp.putAll((Map<?, ?>)env);
            tmp.setProperty("java.naming.security.credentials", "***");
            tmp.setProperty(BIND_CREDENTIAL, "***");
            this.log.trace((Object)("Logging into LDAP server, env=" + tmp.toString()));
        }
    }

    protected String bindDNAuthentication(InitialLdapContext ctx, String user, Object credential, String baseDN, String filter) throws NamingException {
        Attribute dn;
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(this.searchScope);
        constraints.setTimeLimit(this.searchTimeLimit);
        String[] attrList = new String[]{this.distinguishedNameAttribute};
        constraints.setReturningAttributes(attrList);
        NamingEnumeration<SearchResult> results = null;
        Object[] filterArgs = new Object[]{user};
        results = ctx.search(baseDN, filter, filterArgs, constraints);
        if (!results.hasMore()) {
            results.close();
            throw new NamingException("PB00019: Processing Failed:Search of baseDN(" + baseDN + ") found no matches");
        }
        SearchResult sr = results.next();
        String name = sr.getName();
        String userDN = null;
        Attributes attrs = sr.getAttributes();
        if (attrs != null && (dn = attrs.get(this.distinguishedNameAttribute)) != null) {
            userDN = (String)dn.get();
        }
        if (userDN == null) {
            if (sr.isRelative()) {
                userDN = name + ("".equals(baseDN) ? "" : "," + baseDN);
            } else {
                throw new NamingException("PB00019: Processing Failed:Can't follow referal for authentication: " + name);
            }
        }
        results.close();
        results = null;
        InitialLdapContext userCtx = this.constructInitialLdapContext(userDN, credential);
        userCtx.close();
        return userDN;
    }
}

