/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.extractor.tika;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.RepositoryException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.DefaultParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.BodyContentHandler;
import org.modeshape.common.collection.Collections;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.StringUtil;
import org.modeshape.extractor.tika.TikaI18n;
import org.modeshape.extractor.tika.TikaMimeTypeDetector;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.api.text.TextExtractor;
import org.xml.sax.ContentHandler;

public class TikaTextExtractor
extends TextExtractor {
    private static final Logger LOGGER = Logger.getLogger(TikaTextExtractor.class);
    public static final Set<String> DEFAULT_EXCLUDED_MIME_TYPES = Collections.unmodifiableSet((Object[])new String[]{"application/x-archive", "application/x-bzip", "application/x-bzip2", "application/x-cpio", "application/x-gtar", "application/x-gzip", "application/x-tar", "application/zip", "application/vnd.teiid.vdb"});
    private Set<String> excludedMimeTypes = new HashSet<String>();
    private Set<String> includedMimeTypes = new HashSet<String>();
    private Set<String> supportedMediaTypes = new HashSet<String>();
    private final Lock initLock = new ReentrantLock();
    private DefaultParser parser;

    public TikaTextExtractor() {
        this.excludedMimeTypes.addAll(DEFAULT_EXCLUDED_MIME_TYPES);
    }

    public boolean supportsMimeType(String mimeType) {
        if (this.excludedMimeTypes.contains(mimeType)) {
            return false;
        }
        this.initialize();
        return this.includedMimeTypes.isEmpty() ? this.supportedMediaTypes.contains(mimeType) : this.supportedMediaTypes.contains(mimeType) && this.includedMimeTypes.contains(mimeType);
    }

    public void extractFrom(final Binary binary, final TextExtractor.Output output, TextExtractor.Context context) throws Exception {
        final DefaultParser parser = this.initialize();
        this.processStream(binary, (TextExtractor.BinaryOperation)new TextExtractor.BinaryOperation<Object>(){

            public Object execute(InputStream stream) throws Exception {
                Metadata metadata = TikaTextExtractor.this.prepareMetadata(binary);
                try {
                    BodyContentHandler textHandler = new BodyContentHandler();
                    parser.parse(stream, (ContentHandler)textHandler, metadata, new ParseContext());
                    output.recordText(textHandler.toString().trim());
                }
                catch (Throwable e) {
                    LOGGER.error(e, (I18nResource)TikaI18n.errorWhileExtractingTextFrom, new Object[]{e.getMessage()});
                }
                return null;
            }
        });
    }

    private Metadata prepareMetadata(Binary binary) throws IOException, RepositoryException {
        Metadata metadata = new Metadata();
        String mimeType = binary.getMimeType();
        if (StringUtil.isBlank((String)mimeType)) {
            LOGGER.warn((I18nResource)TikaI18n.warnCannotDetectMimeType, new Object[0]);
            mimeType = new TikaMimeTypeDetector().mimeTypeOf(null, (javax.jcr.Binary)binary);
        }
        metadata.set("Content-Type", mimeType);
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DefaultParser initialize() {
        if (this.parser == null) {
            try {
                this.initLock.lock();
                if (this.parser == null) {
                    this.parser = new DefaultParser(((Object)((Object)this)).getClass().getClassLoader());
                }
                Map parsers = this.parser.getParsers();
                for (MediaType mediaType : parsers.keySet()) {
                    String mimeType = mediaType.getType() + "/" + mediaType.getSubtype();
                    this.supportedMediaTypes.add(mimeType);
                }
            }
            finally {
                this.initLock.unlock();
            }
        }
        return this.parser;
    }

    public Set<String> getIncludedMimeTypes() {
        return Collections.unmodifiableSet(this.includedMimeTypes);
    }

    public void setIncludedMimeTypes(String includedMimeTypes) {
        if (includedMimeTypes == null || includedMimeTypes.length() == 0) {
            return;
        }
        this.includedMimeTypes.clear();
        for (String mimeType : includedMimeTypes.split("[,\\s]")) {
            this.includeMimeType(mimeType);
        }
    }

    public void setIncludedMimeTypes(Collection<String> includedMimeTypes) {
        if (includedMimeTypes != null) {
            this.includedMimeTypes = new HashSet<String>(includedMimeTypes);
        }
    }

    private void includeMimeType(String mimeType) {
        if (mimeType == null) {
            return;
        }
        if ((mimeType = mimeType.trim()).length() != 0) {
            this.includedMimeTypes.add(mimeType);
        }
    }

    public Set<String> getExcludedMimeTypes() {
        return Collections.unmodifiableSet(this.excludedMimeTypes);
    }

    public void setExcludedMimeTypes(String excludedMimeTypes) {
        if (excludedMimeTypes == null || excludedMimeTypes.length() == 0) {
            return;
        }
        this.excludedMimeTypes.clear();
        for (String mimeType : excludedMimeTypes.split("[,\\s]")) {
            this.excludeMimeType(mimeType);
        }
    }

    public void setExcludedMimeTypes(Collection<String> excludedMimeTypes) {
        if (excludedMimeTypes != null) {
            this.excludedMimeTypes = new HashSet<String>(excludedMimeTypes);
        }
    }

    private void excludeMimeType(String mimeType) {
        if (mimeType == null) {
            return;
        }
        if ((mimeType = mimeType.trim()).length() != 0) {
            this.excludedMimeTypes.add(mimeType);
        }
    }
}

