/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config.parsing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import org.infinispan.Cache;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.config.parsing.ConfigFilesConvertor;
import org.infinispan.config.parsing.Jbc2InfinispanTransformerTest;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="config.parsing.EHCache2InfinispanTransformerTest")
public class EHCache2InfinispanTransformerTest
extends AbstractInfinispanTest {
    private static final String BASE_DIR = "configs/ehcache";
    ConfigFilesConvertor convertor = new ConfigFilesConvertor();

    public void testEhCache16File() throws Exception {
        this.testAllFile("/ehcache-1.6.xml");
    }

    public void testEhCache15File() throws Exception {
        this.testAllFile("/ehcache-1.5.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAllFile(String ehCacheFile) throws Exception {
        ClassLoader existingCl = Thread.currentThread().getContextClassLoader();
        DefaultCacheManager dcm = null;
        Cache sampleDistributedCache2 = null;
        try {
            Jbc2InfinispanTransformerTest.TestClassLoader delegatingCl = new Jbc2InfinispanTransformerTest.TestClassLoader(existingCl);
            Thread.currentThread().setContextClassLoader(delegatingCl);
            String fileName = this.getFileName(ehCacheFile);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.convertor.parse(fileName, (OutputStream)baos, (String)ConfigFilesConvertor.TRANSFORMATIONS.get("Ehcache1x"), Thread.currentThread().getContextClassLoader());
            dcm = (DefaultCacheManager)TestCacheManagerFactory.fromStream(new ByteArrayInputStream(baos.toByteArray()));
            Cache defaultCache = dcm.getCache();
            defaultCache.put((Object)"key", (Object)"value");
            Configuration configuration = defaultCache.getConfiguration();
            Assert.assertEquals((int)configuration.getEvictionMaxEntries(), (int)10000);
            Assert.assertEquals((long)configuration.getExpirationMaxIdle(), (long)121L);
            Assert.assertEquals((long)configuration.getExpirationLifespan(), (long)122L);
            CacheLoaderManagerConfig clmConfig = configuration.getCacheLoaderManagerConfig();
            assert (clmConfig != null);
            CacheLoaderConfig loaderConfig = (CacheLoaderConfig)clmConfig.getCacheLoaderConfigs().get(0);
            assert (loaderConfig.getCacheLoaderClassName().equals("org.infinispan.loaders.file.FileCacheStore"));
            Assert.assertEquals((long)configuration.getExpirationWakeUpInterval(), (long)119000L);
            Assert.assertEquals((Object)configuration.getEvictionStrategy(), (Object)EvictionStrategy.LRU);
            assert (dcm.getDefinedCacheNames().contains("sampleCache1"));
            assert (dcm.getDefinedCacheNames().contains("sampleCache2"));
            assert (dcm.getDefinedCacheNames().contains("sampleCache3"));
            assert (dcm.getDefinedCacheNames().contains("sampleDistributedCache1"));
            assert (dcm.getDefinedCacheNames().contains("sampleDistributedCache2"));
            assert (dcm.getDefinedCacheNames().contains("sampleDistributedCache3"));
            sampleDistributedCache2 = dcm.getCache("sampleDistributedCache2");
            assert (sampleDistributedCache2.getConfiguration().getCacheLoaderManagerConfig().getCacheLoaderConfigs().size() == 1);
            assert (sampleDistributedCache2.getConfiguration().getExpirationLifespan() == 101L);
            assert (sampleDistributedCache2.getConfiguration().getExpirationMaxIdle() == 102L);
            Assert.assertEquals((Object)sampleDistributedCache2.getConfiguration().getCacheMode(), (Object)Configuration.CacheMode.INVALIDATION_SYNC);
            Thread.currentThread().setContextClassLoader(existingCl);
        }
        catch (Throwable throwable) {
            Thread.currentThread().setContextClassLoader(existingCl);
            TestingUtil.killCaches(sampleDistributedCache2);
            TestingUtil.killCacheManagers(new EmbeddedCacheManager[]{dcm});
            throw throwable;
        }
        TestingUtil.killCaches(sampleDistributedCache2);
        TestingUtil.killCacheManagers(new EmbeddedCacheManager[]{dcm});
    }

    private String getFileName(String s) {
        return BASE_DIR + File.separator + s;
    }
}

