/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning;

import java.util.concurrent.ConcurrentSkipListSet;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.annotations.Test;

@Test(testName="container.versioning.AbstractClusteredWriteSkewTest", groups={"functional"})
public abstract class AbstractClusteredWriteSkewTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        builder.clustering().cacheMode(this.getCacheMode()).versioning().enable().scheme(VersioningScheme.SIMPLE).locking().isolationLevel(IsolationLevel.REPEATABLE_READ).writeSkewCheck(true).transaction().lockingMode(LockingMode.OPTIMISTIC).syncCommitPhase(true);
        this.decorate(builder);
        this.createCluster(builder, this.clusterSize());
        this.waitForClusterToForm();
    }

    protected void decorate(ConfigurationBuilder builder) {
    }

    protected abstract CacheMode getCacheMode();

    protected abstract int clusterSize();

    public void testSharedCounter() {
        IncrementCounterThread ict2;
        IncrementCounterThread ict1;
        Cache c2;
        Cache c1;
        int counterMaxValue;
        block8: {
            counterMaxValue = 1000;
            c1 = this.cache(0);
            c2 = this.cache(1);
            c1.put((Object)"counter", (Object)0);
            assert ((Integer)c1.get((Object)"counter") == 0) : "Initial value is different from zero in cache 1";
            assert ((Integer)c2.get((Object)"counter") == 0) : "Initial value is different from zero in cache 2";
            ConcurrentSkipListSet<Integer> uniqueValuesIncremented = new ConcurrentSkipListSet<Integer>();
            ict1 = new IncrementCounterThread("Node-1", c1, uniqueValuesIncremented, counterMaxValue);
            ict2 = new IncrementCounterThread("Node-2", c2, uniqueValuesIncremented, counterMaxValue);
            try {
                ict1.start();
                ict2.start();
                ict1.join();
                ict2.join();
            }
            catch (InterruptedException e) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError((Object)"Interrupted exception while running the test");
            }
        }
        assert ((Integer)c1.get((Object)"counter") >= counterMaxValue) : "Final value is less than " + counterMaxValue + " in cache 1";
        assert ((Integer)c2.get((Object)"counter") >= counterMaxValue) : "Final value is less than " + counterMaxValue + " in cache 2";
        assert (ict1.result) : ict1.getName() + " has put a duplicate value";
        assert (ict2.result) : ict2.getName() + " has put a duplicate value";
    }

    private static class IncrementCounterThread
    extends Thread {
        private Cache<String, Integer> cache;
        private ConcurrentSkipListSet<Integer> uniqueValuesSet;
        private TransactionManager transactionManager;
        private int lastValue;
        private boolean result = true;
        private int counterMaxValue;

        public IncrementCounterThread(String name, Cache<String, Integer> cache, ConcurrentSkipListSet<Integer> uniqueValuesSet, int counterMaxValue) {
            super(name);
            this.cache = cache;
            this.transactionManager = cache.getAdvancedCache().getTransactionManager();
            this.uniqueValuesSet = uniqueValuesSet;
            this.lastValue = 0;
            this.counterMaxValue = counterMaxValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.lastValue < this.counterMaxValue) {
                try {
                    try {
                        this.transactionManager.begin();
                        Integer value = (Integer)this.cache.get((Object)"counter");
                        value = value + 1;
                        this.lastValue = value;
                        this.cache.put((Object)"counter", (Object)value);
                        this.transactionManager.commit();
                        this.result = this.uniqueValuesSet.add(value);
                    }
                    catch (Throwable t) {
                        this.transactionManager.rollback();
                    }
                }
                catch (Throwable throwable) {
                    assert (this.result) : "Duplicate value found in " + this.getName() + " (value=" + this.lastValue + ")";
                }
                finally {
                    if ($assertionsDisabled || this.result) continue;
                    throw new AssertionError((Object)("Duplicate value found in " + this.getName() + " (value=" + this.lastValue + ")"));
                }
            }
        }
    }
}

