/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distexec;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distexec.BasicDistributedExecutorTest")
public class BasicDistributedExecutorTest
extends AbstractCacheTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={IllegalStateException.class})
    public void testImproperCacheStateForDistribtuedExecutor() {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createLocalCacheManager(false);
        try {
            Cache cache = cacheManager.getCache();
            DefaultExecutorService defaultExecutorService = new DefaultExecutorService(cache);
        }
        finally {
            cacheManager.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSingleCacheExecution() throws Exception {
        Configuration config = TestCacheManagerFactory.getDefaultConfiguration(true, Configuration.CacheMode.REPL_SYNC);
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager(config);
        try {
            Cache cache = cacheManager.getCache();
            DefaultExecutorService des = new DefaultExecutorService(cache);
            Future future = des.submit((Callable)new SimpleCallable());
            Integer r = (Integer)future.get();
            assert (r == 1);
            List list = des.submitEverywhere((Callable)new SimpleCallable());
            assert (list.size() == 1);
            for (Future f : list) {
                assert ((Integer)f.get() == 1);
            }
        }
        finally {
            cacheManager.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSingleCacheWithKeysExecution() throws Exception {
        Configuration config = TestCacheManagerFactory.getDefaultConfiguration(true, Configuration.CacheMode.REPL_SYNC);
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createClusteredCacheManager(config);
        try {
            Cache c1 = cacheManager.getCache();
            c1.put((Object)"key1", (Object)"Manik");
            c1.put((Object)"key2", (Object)"Mircea");
            c1.put((Object)"key3", (Object)"Galder");
            c1.put((Object)"key4", (Object)"Sanne");
            DefaultExecutorService des = new DefaultExecutorService(c1);
            Future future = des.submit((Callable)((Object)new SimpleDistributedCallable(true)), (Object[])new String[]{"key1", "key2"});
            Boolean r = (Boolean)future.get();
            assert (r.booleanValue());
        }
        finally {
            cacheManager.stop();
        }
    }

    static class SimpleCallable
    implements Callable<Integer>,
    Serializable {
        private static final long serialVersionUID = -8589149500259272402L;

        SimpleCallable() {
        }

        @Override
        public Integer call() throws Exception {
            return 1;
        }
    }

    static class SimpleDistributedCallable
    implements DistributedCallable<String, String, Boolean>,
    Serializable {
        private static final long serialVersionUID = 623845442163221832L;
        private boolean invokedProperly = false;
        private final boolean hasKeys;

        public SimpleDistributedCallable(boolean hasKeys) {
            this.hasKeys = hasKeys;
        }

        public Boolean call() throws Exception {
            return this.invokedProperly;
        }

        public void setEnvironment(Cache<String, String> cache, Set<String> inputKeys) {
            boolean keysProperlySet = this.hasKeys ? inputKeys != null && !inputKeys.isEmpty() : inputKeys != null && inputKeys.isEmpty();
            this.invokedProperly = cache != null && keysProperlySet;
        }

        public boolean validlyInvoked() {
            return this.invokedProperly;
        }
    }
}

