/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.rehash.DataLossOnJoinOneOwnerTest")
public class DataLossOnJoinOneOwnerTest
extends AbstractInfinispanTest {
    private static final String VALUE = DataLossOnJoinOneOwnerTest.class.getName() + "value";
    private static final String KEY = DataLossOnJoinOneOwnerTest.class.getName() + "key";
    EmbeddedCacheManager cm1;
    EmbeddedCacheManager cm2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDataLossOnJoin() {
        try {
            this.cm1 = this.newCM();
            Cache c1 = this.cm1.getCache();
            c1.put((Object)KEY, (Object)VALUE);
            this.hasKey((Cache<String, String>)c1);
            this.cm2 = this.newCM();
            Cache c2 = this.cm2.getCache();
            TestingUtil.blockUntilViewsReceived(45000L, new CacheContainer[]{this.cm1, this.cm2});
            this.hasKey((Cache<String, String>)c1);
            this.hasKey((Cache<String, String>)c2);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(this.cm1, this.cm2);
            throw throwable;
        }
        TestingUtil.killCacheManagers(this.cm1, this.cm2);
    }

    private void hasKey(Cache<String, String> cache) {
        Object object = cache.get((Object)KEY);
        assert (VALUE.equals(object));
    }

    public EmbeddedCacheManager newCM() {
        GlobalConfiguration gc = GlobalConfiguration.getClusteredDefault();
        Configuration c = new Configuration().fluent().mode(Configuration.CacheMode.DIST_SYNC).hash().numOwners(Integer.valueOf(1)).clustering().l1().disable().build();
        return TestCacheManagerFactory.createCacheManager(gc, c);
    }
}

