/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.lang.reflect.Method;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ServiceNotFoundException;
import org.infinispan.config.Configuration;
import org.infinispan.jmx.PerThreadMBeanServerLookup;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.CacheManagerMBeanTest")
public class CacheManagerMBeanTest
extends SingleCacheManagerTest {
    public static final String JMX_DOMAIN = CacheManagerMBeanTest.class.getSimpleName();
    private MBeanServer server;
    private ObjectName name;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManagerEnforceJmxDomain(JMX_DOMAIN, true, false);
        this.name = TestingUtil.getCacheManagerObjectName(JMX_DOMAIN);
        this.server = PerThreadMBeanServerLookup.getThreadMBeanServer();
        this.server.invoke(this.name, "startCache", new Object[0], new String[0]);
        return this.cacheManager;
    }

    public void testJmxOperations() throws Exception {
        assert (this.server.getAttribute(this.name, "CreatedCacheCount").equals("1"));
        assert (this.server.getAttribute(this.name, "DefinedCacheCount").equals("0")) : "Was " + this.server.getAttribute(this.name, "DefinedCacheCount");
        assert (this.server.getAttribute(this.name, "DefinedCacheNames").equals("[]"));
        assert (this.server.getAttribute(this.name, "RunningCacheCount").equals("1"));
        this.cacheManager.defineConfiguration("a", new Configuration());
        this.cacheManager.defineConfiguration("b", new Configuration());
        this.cacheManager.defineConfiguration("c", new Configuration());
        assert (this.server.getAttribute(this.name, "CreatedCacheCount").equals("1"));
        assert (this.server.getAttribute(this.name, "DefinedCacheCount").equals("3"));
        assert (this.server.getAttribute(this.name, "RunningCacheCount").equals("1"));
        String attribute = (String)this.server.getAttribute(this.name, "DefinedCacheNames");
        assert (attribute.contains("a("));
        assert (attribute.contains("b("));
        assert (attribute.contains("c("));
        this.server.invoke(this.name, "startCache", new Object[]{"a"}, new String[]{String.class.getName()});
        this.server.invoke(this.name, "startCache", new Object[]{"b"}, new String[]{String.class.getName()});
        assert (this.server.getAttribute(this.name, "CreatedCacheCount").equals("3"));
        assert (this.server.getAttribute(this.name, "DefinedCacheCount").equals("3"));
        assert (this.server.getAttribute(this.name, "RunningCacheCount").equals("3"));
        attribute = (String)this.server.getAttribute(this.name, "DefinedCacheNames");
        assert (attribute.contains("a("));
        assert (attribute.contains("b("));
        assert (attribute.contains("c("));
    }

    public void testInvokeJmxOperationNotExposed() throws Exception {
        block3: {
            try {
                this.server.invoke(this.name, "stop", new Object[0], new String[0]);
                assert (false) : "Method not exposed, invocation should have failed";
            }
            catch (MBeanException mbe) {
                if ($assertionsDisabled || mbe.getCause() instanceof ServiceNotFoundException) break block3;
                throw new AssertionError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJmxRegistrationAtStartupAndStop(Method m) throws Exception {
        String otherJmxDomain = TestingUtil.getMethodSpecificJmxDomain(m, JMX_DOMAIN);
        EmbeddedCacheManager otherContainer = TestCacheManagerFactory.createCacheManagerEnforceJmxDomain(otherJmxDomain, true, false);
        ObjectName otherName = TestingUtil.getCacheManagerObjectName(otherJmxDomain);
        try {
            assert (this.server.getAttribute(otherName, "CreatedCacheCount").equals("0"));
        }
        finally {
            otherContainer.stop();
        }
        try {
            this.server.getAttribute(otherName, "CreatedCacheCount").equals("0");
            assert (false) : "Failure expected, " + otherName + " shouldn't be registered in mbean server";
        }
        catch (InstanceNotFoundException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCustomCacheManagerName(Method m) throws Exception {
        String otherJmxDomain = TestingUtil.getMethodSpecificJmxDomain(m, JMX_DOMAIN);
        EmbeddedCacheManager otherContainer = TestCacheManagerFactory.createCacheManagerEnforceJmxDomain(otherJmxDomain, "Hibernate2LC", true, false);
        ObjectName otherName = TestingUtil.getCacheManagerObjectName(otherJmxDomain, "Hibernate2LC");
        try {
            assert (this.server.getAttribute(otherName, "CreatedCacheCount").equals("0"));
        }
        finally {
            otherContainer.stop();
        }
    }

    public void testAddressInformation() throws Exception {
        assert (this.server.getAttribute(this.name, "NodeAddress").equals("local"));
        assert (this.server.getAttribute(this.name, "ClusterMembers").equals("local"));
        assert (this.server.getAttribute(this.name, "PhysicalAddresses").equals("local"));
        assert (this.server.getAttribute(this.name, "ClusterSize").equals(1));
    }
}

