/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.easymock.EasyMock;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.jmx.PerThreadMBeanServerLookup;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcManagerImpl;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.RpcManagerMBeanTest")
public class RpcManagerMBeanTest
extends MultipleCacheManagersTest {
    private final String cachename = "repl_sync_cache";
    public static final String JMX_DOMAIN = RpcManagerMBeanTest.class.getSimpleName();
    public static final String JMX_DOMAIN2 = JMX_DOMAIN + "2";

    @Override
    protected void createCacheManagers() throws Throwable {
        GlobalConfiguration globalConfiguration = GlobalConfiguration.getClusteredDefault();
        globalConfiguration.setExposeGlobalJmxStatistics(true);
        globalConfiguration.setAllowDuplicateDomains(true);
        globalConfiguration.setJmxDomain(JMX_DOMAIN);
        globalConfiguration.setMBeanServerLookup(PerThreadMBeanServerLookup.class.getName());
        EmbeddedCacheManager cacheManager1 = TestCacheManagerFactory.createCacheManagerEnforceJmxDomain(globalConfiguration);
        cacheManager1.start();
        GlobalConfiguration globalConfiguration2 = GlobalConfiguration.getClusteredDefault();
        globalConfiguration2.setExposeGlobalJmxStatistics(true);
        globalConfiguration2.setMBeanServerLookup(PerThreadMBeanServerLookup.class.getName());
        globalConfiguration2.setJmxDomain(JMX_DOMAIN);
        globalConfiguration2.setAllowDuplicateDomains(true);
        EmbeddedCacheManager cacheManager2 = TestCacheManagerFactory.createCacheManagerEnforceJmxDomain(globalConfiguration2);
        cacheManager2.start();
        this.registerCacheManager(new CacheContainer[]{cacheManager1, cacheManager2});
        Configuration config = RpcManagerMBeanTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC);
        config.setExposeJmxStatistics(true);
        this.defineConfigurationOnAllManagers("repl_sync_cache", config);
    }

    public void testEnableJmxStats() throws Exception {
        Cache cache1 = this.manager(0).getCache("repl_sync_cache");
        Cache cache2 = this.manager(1).getCache("repl_sync_cache");
        MBeanServer mBeanServer = PerThreadMBeanServerLookup.getThreadMBeanServer();
        ObjectName rpcManager1 = TestingUtil.getCacheObjectName(JMX_DOMAIN, "repl_sync_cache(repl_sync)", "RpcManager");
        ObjectName rpcManager2 = TestingUtil.getCacheObjectName(JMX_DOMAIN2, "repl_sync_cache(repl_sync)", "RpcManager");
        assert (mBeanServer.isRegistered(rpcManager1));
        assert (mBeanServer.isRegistered(rpcManager2));
        Object statsEnabled = mBeanServer.getAttribute(rpcManager1, "StatisticsEnabled");
        assert (statsEnabled != null);
        assert (statsEnabled.equals(Boolean.TRUE));
        assert (mBeanServer.getAttribute(rpcManager1, "StatisticsEnabled").equals(Boolean.TRUE));
        assert (mBeanServer.getAttribute(rpcManager2, "StatisticsEnabled").equals(Boolean.TRUE));
        long initialReplicationCount1 = (Long)mBeanServer.getAttribute(rpcManager1, "ReplicationCount");
        cache1.put((Object)"key", (Object)"value2");
        assert (cache2.get((Object)"key").equals("value2"));
        assert (mBeanServer.getAttribute(rpcManager1, "ReplicationCount").equals(initialReplicationCount1 + 1L)) : "Expected " + (initialReplicationCount1 + 1L) + ", was " + mBeanServer.getAttribute(rpcManager1, "ReplicationCount");
        assert (mBeanServer.getAttribute(rpcManager1, "ReplicationFailures").equals(0L));
        mBeanServer.invoke(rpcManager1, "resetStatistics", new Object[0], new String[0]);
        assert (mBeanServer.getAttribute(rpcManager1, "ReplicationCount").equals(0L));
        assert (mBeanServer.getAttribute(rpcManager1, "ReplicationFailures").equals(0L));
        mBeanServer.setAttribute(rpcManager1, new Attribute("StatisticsEnabled", Boolean.FALSE));
        cache1.put((Object)"key", (Object)"value");
        assert (cache2.get((Object)"key").equals("value"));
        assert (mBeanServer.getAttribute(rpcManager1, "ReplicationCount").equals(-1L));
        assert (mBeanServer.getAttribute(rpcManager1, "ReplicationCount").equals(-1L));
        mBeanServer.setAttribute(rpcManager1, new Attribute("StatisticsEnabled", Boolean.TRUE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dependsOnMethods={"testEnableJmxStats"})
    public void testSuccessRatio() throws Exception {
        Cache cache1 = this.manager(0).getCache("repl_sync_cache");
        Cache cache2 = this.manager(1).getCache("repl_sync_cache");
        MBeanServer mBeanServer = PerThreadMBeanServerLookup.getThreadMBeanServer();
        ObjectName rpcManager1 = TestingUtil.getCacheObjectName(JMX_DOMAIN, "repl_sync_cache(repl_sync)", "RpcManager");
        assert (mBeanServer.getAttribute(rpcManager1, "ReplicationCount").equals(0L));
        assert (mBeanServer.getAttribute(rpcManager1, "ReplicationFailures").equals(0L));
        assert (mBeanServer.getAttribute(rpcManager1, "SuccessRatio").equals("N/A"));
        cache1.put((Object)"a1", (Object)new SlowToSerialize("b1", 50L));
        cache1.put((Object)"a2", (Object)new SlowToSerialize("b2", 50L));
        cache1.put((Object)"a3", (Object)new SlowToSerialize("b3", 50L));
        cache1.put((Object)"a4", (Object)new SlowToSerialize("b4", 50L));
        assert (mBeanServer.getAttribute(rpcManager1, "ReplicationCount").equals(4L));
        assert (mBeanServer.getAttribute(rpcManager1, "SuccessRatio").equals("100%"));
        Object avgReplTime = mBeanServer.getAttribute(rpcManager1, "AverageReplicationTime");
        assert (!avgReplTime.equals(0L)) : "Expected !0, was " + avgReplTime;
        RpcManagerImpl rpcManager = (RpcManagerImpl)TestingUtil.extractComponent(cache1, RpcManager.class);
        Transport originalTransport = rpcManager.getTransport();
        try {
            Address mockAddress1 = (Address)EasyMock.createNiceMock(Address.class);
            Address mockAddress2 = (Address)EasyMock.createNiceMock(Address.class);
            ArrayList<Address> memberList = new ArrayList<Address>(2);
            memberList.add(mockAddress1);
            memberList.add(mockAddress2);
            Transport transport = (Transport)EasyMock.createMock(Transport.class);
            EasyMock.expect((Object)transport.getMembers()).andReturn(memberList).anyTimes();
            EasyMock.expect((Object)transport.getAddress()).andReturn(null).anyTimes();
            EasyMock.expect((Object)transport.invokeRemotely((Collection)EasyMock.anyObject(), (ReplicableCommand)EasyMock.anyObject(), (ResponseMode)EasyMock.anyObject(), EasyMock.anyLong(), EasyMock.anyBoolean(), (ResponseFilter)EasyMock.anyObject(), EasyMock.anyBoolean())).andThrow((Throwable)new RuntimeException()).anyTimes();
            EasyMock.replay((Object[])new Object[]{transport});
            rpcManager.setTransport(transport);
            cache1.put((Object)"a5", (Object)"b5");
            assert (false) : "rpc manager should have thrown an exception";
        }
        catch (Throwable expected) {
            Assert.assertEquals((Object)mBeanServer.getAttribute(rpcManager1, "SuccessRatio"), (Object)"80%");
        }
        finally {
            rpcManager.setTransport(originalTransport);
        }
    }

    public static class SlowToSerialize
    implements Externalizable {
        String val;
        transient long delay;

        public SlowToSerialize() {
        }

        private SlowToSerialize(String val, long delay) {
            this.val = val;
            this.delay = delay;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.val);
            TestingUtil.sleepThread(this.delay);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.val = (String)in.readObject();
            TestingUtil.sleepThread(this.delay);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SlowToSerialize that = (SlowToSerialize)o;
            return !(this.val != null ? !this.val.equals(that.val) : that.val != null);
        }

        public int hashCode() {
            return this.val != null ? this.val.hashCode() : 0;
        }
    }
}

