/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import java.lang.reflect.Method;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.config.Configuration;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="notifications.cachelistener.ListenerExceptionTest")
public class ListenerExceptionTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration cfg = ListenerExceptionTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC, true);
        this.createClusteredCaches(2, cfg);
    }

    public void testPreOpExceptionListenerOnCreate(Method m) {
        this.doCallsWithExcepList(m, true, FailureLocation.ON_CREATE);
    }

    public void testPostOpExceptionListenerOnCreate(Method m) {
        this.doCallsWithExcepList(m, false, FailureLocation.ON_CREATE);
    }

    public void testPreOpExceptionListenerOnPut(Method m) {
        this.manager(0).getCache().put((Object)TestingUtil.k(m), (Object)"init");
        this.doCallsWithExcepList(m, true, FailureLocation.ON_MODIFIED);
    }

    public void testPostOpExceptionListenerOnPut(Method m) {
        this.manager(0).getCache().put((Object)TestingUtil.k(m), (Object)"init");
        this.doCallsWithExcepList(m, false, FailureLocation.ON_MODIFIED);
    }

    private void doCallsWithExcepList(Method m, boolean isInjectInPre, FailureLocation failLoc) {
        Cache cache = this.manager(0).getCache();
        ErrorInducingListener listener = new ErrorInducingListener(isInjectInPre, failLoc);
        cache.addListener((Object)listener);
        try {
            cache.put((Object)TestingUtil.k(m), (Object)TestingUtil.v(m));
        }
        catch (CacheException e) {
            assert (e.getCause() instanceof SuspectException);
            listener.injectFailure = false;
            this.manager(1).getCache().put((Object)TestingUtil.k(m), (Object)TestingUtil.v(m, 2));
            return;
        }
        AssertJUnit.fail((String)"Should have failed");
    }

    private static enum FailureLocation {
        ON_CREATE,
        ON_MODIFIED;

    }

    @Listener
    public static class ErrorInducingListener {
        boolean injectFailure = true;
        boolean isInjectInPre;
        FailureLocation failureLocation;

        public ErrorInducingListener(boolean injectInPre, FailureLocation failLoc) {
            this.isInjectInPre = injectInPre;
            this.failureLocation = failLoc;
        }

        @CacheEntryCreated
        public void entryCreated(CacheEntryEvent event) throws Exception {
            if (this.failureLocation == FailureLocation.ON_CREATE) {
                this.injectFailure(event);
            }
        }

        @CacheEntryModified
        public void entryModified(CacheEntryEvent event) throws Exception {
            if (this.failureLocation == FailureLocation.ON_MODIFIED) {
                this.injectFailure(event);
            }
        }

        private void injectFailure(CacheEntryEvent event) {
            if (this.injectFailure) {
                if (this.isInjectInPre && event.isPre()) {
                    this.throwSuspectException();
                } else if (!this.isInjectInPre && !event.isPre()) {
                    this.throwSuspectException();
                }
            }
        }

        private void throwSuspectException() {
            throw new SuspectException(String.format("Simulated suspicion when isPre=%b and in %s", new Object[]{this.isInjectInPre, this.failureLocation}));
        }
    }
}

