/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.replication;

import java.util.List;
import java.util.Map;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.config.Configuration;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.event.TransactionalEvent;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="replication.SyncCacheListenerTest")
public class SyncCacheListenerTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(SyncCacheListenerTest.class);
    private Cache<Object, Object> cache1;
    private Cache<Object, Object> cache2;

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration conf = SyncCacheListenerTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC, true);
        conf.setIsolationLevel(IsolationLevel.SERIALIZABLE);
        conf.setLockAcquisitionTimeout(5000L);
        List caches = this.createClusteredCaches(2, "cache", conf);
        this.cache1 = caches.get(0);
        this.cache2 = caches.get(1);
    }

    public void testSyncTxRepl() throws Exception {
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache1);
        tm.begin();
        Transaction tx = tm.getTransaction();
        LocalListener lis = new LocalListener();
        this.cache1.addListener((Object)lis);
        lis.put("age", 38);
        tm.suspend();
        AssertJUnit.assertNull((String)"age on cache2 must be null as the TX has not yet been committed", (Object)this.cache2.get((Object)"age"));
        tm.resume(tx);
        tm.commit();
        Integer age = (Integer)this.cache2.get((Object)"age");
        AssertJUnit.assertNotNull((String)"\"age\" obtained from cache2 must be non-null ", (Object)age);
        AssertJUnit.assertTrue((String)"\"age\" must be 38", (age == 38 ? 1 : 0) != 0);
    }

    public void testRemoteCacheListener() throws Exception {
        RemoteListener lis = new RemoteListener();
        this.cache2.addListener((Object)lis);
        this.cache1.put((Object)"age", (Object)38);
        Integer age = (Integer)this.cache2.get((Object)"age");
        AssertJUnit.assertNotNull((String)"\"age\" obtained from cache2 must be non-null ", (Object)age);
        AssertJUnit.assertTrue((String)"\"age\" must be 38", (age == 38 ? 1 : 0) != 0);
        this.cache1.remove((Object)"age");
    }

    public void testSyncRepl() throws Exception {
        LocalListener lis = new LocalListener();
        this.cache1.addListener((Object)lis);
        lis.put("age", 38);
        Integer age = (Integer)this.cache2.get((Object)"age");
        AssertJUnit.assertNotNull((String)"\"age\" obtained from cache2 must be non-null ", (Object)age);
        AssertJUnit.assertTrue((String)"\"age\" must be 38", (age == 38 ? 1 : 0) != 0);
    }

    public void simpleReplicationTest() throws Exception {
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache1);
        tm.begin();
        this.cache1.put((Object)"key", (Object)"value");
        tm.commit();
        assert (this.cache2.get((Object)"key").equals("value"));
    }

    public void testSyncTxReplMap() throws Exception {
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache1);
        tm.begin();
        Transaction tx = tm.getTransaction();
        LocalListener lis = new LocalListener();
        this.cache1.put((Object)"age", (Object)38);
        lis.put("name", "Ben");
        assert (this.cache1.get((Object)"age").equals(38));
        tm.suspend();
        AssertJUnit.assertNull((String)"age on cache2 must be null as the TX has not yet been committed", (Object)this.cache2.get((Object)"age"));
        AssertJUnit.assertNull((String)"age on cache1 must be null as the TX has been resumed", (Object)this.cache1.get((Object)"age"));
        tm.resume(tx);
        AssertJUnit.assertNotNull((String)"age on cache1 must be not be null", (Object)this.cache1.get((Object)"age"));
        tm.commit();
        AssertJUnit.assertNotNull((String)"age on cache1 must be not be null", (Object)this.cache1.get((Object)"age"));
        System.out.println("  ********************** ");
        Integer age = (Integer)this.cache2.get((Object)"age");
        AssertJUnit.assertNotNull((String)"\"age\" obtained from cache2 must be non-null ", (Object)age);
        AssertJUnit.assertTrue((String)"\"age\" must be 38", (age == 38 ? 1 : 0) != 0);
    }

    public void testSyncReplMap() throws Exception {
        LockManager lm1 = TestingUtil.extractComponent(this.cache1, LockManager.class);
        assert (lm1.getOwner((Object)"age") == null) : "lock info is " + lm1.printLockInfo();
        LocalListener lis = new LocalListener();
        this.cache1.addListener((Object)lis);
        lis.put("age", 38);
        assert (lm1.getOwner((Object)"age") == null) : "lock info is " + lm1.printLockInfo();
        this.cache1.put((Object)"name", (Object)"Ben");
        Integer age = (Integer)this.cache2.get((Object)"age");
        AssertJUnit.assertNotNull((String)"\"age\" obtained from cache2 must be non-null ", (Object)age);
        AssertJUnit.assertTrue((String)"\"age\" must be 38", (age == 38 ? 1 : 0) != 0);
        assert (lm1.getOwner((Object)"age") == null) : "lock info is " + lm1.printLockInfo();
    }

    @Listener
    public static class RemoteListener {
        @CacheEntryRemoved
        @CacheEntryModified
        public void callback(TransactionalEvent e) {
            System.out.println("Callback got event " + e);
            log.debug((Object)("Callback got event " + e));
            AssertJUnit.assertFalse((String)"entry was removed on remote cache so isLocal should be false", (boolean)e.isOriginLocal());
        }
    }

    @Listener
    public class LocalListener {
        Object key = null;

        public void put(Object key, Object val) {
            this.key = key;
            SyncCacheListenerTest.this.cache1.put(key, val);
        }

        public void put(Map map) {
            if (map.isEmpty()) {
                AssertJUnit.fail((String)"put(): map size can't be 0");
            }
            SyncCacheListenerTest.this.cache1.putAll(map);
        }

        @CacheEntryModified
        public void modified(Event ne) {
            if (!ne.isPre()) {
                log.debug((Object)("modified visited with key: " + this.key));
                try {
                    SyncCacheListenerTest.this.cache1.get(this.key);
                }
                catch (CacheException e) {
                    e.printStackTrace();
                    AssertJUnit.fail((String)("modified: test failed with exception: " + (Object)((Object)e)));
                }
            }
        }
    }
}

