/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import org.infinispan.Cache;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.statetransfer.StateTransferFunctionalTest;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.StateTransferCacheLoaderFunctionalTest", enabled=true)
public class StateTransferCacheLoaderFunctionalTest
extends StateTransferFunctionalTest {
    int id;
    ThreadLocal<Boolean> sharedCacheLoader = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public StateTransferCacheLoaderFunctionalTest() {
        super("nbst-with-loader");
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() {
        CacheLoaderManagerConfig clmc = new CacheLoaderManagerConfig();
        DummyInMemoryCacheStore.Cfg clc = new DummyInMemoryCacheStore.Cfg("store number " + this.id++);
        clmc.addCacheLoaderConfig((CacheLoaderConfig)clc);
        clc.setFetchPersistentState(true);
        clmc.setShared(this.sharedCacheLoader.get());
        this.config.setCacheLoaderManagerConfig(clmc);
        return super.createCacheManager();
    }

    @Override
    protected void writeInitialData(Cache<Object, Object> c) {
        super.writeInitialData(c);
        c.evict((Object)"a_b_name");
        c.evict((Object)"a_b_age");
        c.evict((Object)"a_c_name");
        c.evict((Object)"a_c_age");
        c.evict((Object)"a_d_age");
        c.evict((Object)"a_d_age");
    }

    protected void verifyInitialDataOnLoader(Cache<Object, Object> c) throws Exception {
        CacheLoader l = TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheLoader();
        assert (l.containsKey((Object)"a_b_age"));
        assert (l.containsKey((Object)"a_b_name"));
        assert (l.containsKey((Object)"a_c_age"));
        assert (l.containsKey((Object)"a_c_name"));
        assert (l.load((Object)"a_b_age").getValue().equals(TWENTY));
        assert (l.load((Object)"a_b_name").getValue().equals("JOE"));
        assert (l.load((Object)"a_c_age").getValue().equals(FORTY));
        assert (l.load((Object)"a_c_name").getValue().equals("BOB"));
    }

    protected void verifyNoData(Cache<Object, Object> c) {
        assert (c.isEmpty()) : "Cache should be empty!";
    }

    protected void verifyNoDataOnLoader(Cache<Object, Object> c) throws Exception {
        CacheLoader l = TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheLoader();
        assert (!l.containsKey((Object)"a_b_age"));
        assert (!l.containsKey((Object)"a_b_name"));
        assert (!l.containsKey((Object)"a_c_age"));
        assert (!l.containsKey((Object)"a_c_name"));
        assert (!l.containsKey((Object)"a_d_age"));
        assert (!l.containsKey((Object)"a_d_age"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSharedLoader() throws Exception {
        try {
            this.sharedCacheLoader.set(true);
            Cache c1 = this.createCacheManager().getCache(this.cacheName);
            this.writeInitialData((Cache<Object, Object>)c1);
            Cache c2 = this.createCacheManager().getCache(this.cacheName);
            TestingUtil.blockUntilViewsReceived(60000L, c1, c2);
            this.verifyInitialDataOnLoader((Cache<Object, Object>)c1);
            this.verifyInitialData((Cache<Object, Object>)c1);
            this.verifyNoDataOnLoader((Cache<Object, Object>)c2);
            this.verifyNoData((Cache<Object, Object>)c2);
        }
        finally {
            this.sharedCacheLoader.set(false);
        }
    }
}

