/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.lang.reflect.Method;
import org.infinispan.Cache;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.StateTransferFetchOnlyPersistentStateTest")
public class StateTransferFetchOnlyPersistentStateTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration cfg = this.createConfiguration(1);
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager();
        cm.defineConfiguration("onlyFetchPersistent", cfg);
    }

    private Configuration createConfiguration(int id) {
        Configuration cfg = StateTransferFetchOnlyPersistentStateTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC, true);
        cfg.fluent().clustering().stateRetrieval().fetchInMemoryState(Boolean.valueOf(false));
        CacheLoaderManagerConfig clmc = new CacheLoaderManagerConfig();
        DummyInMemoryCacheStore.Cfg clc = new DummyInMemoryCacheStore.Cfg("store id: " + id);
        clmc.addCacheLoaderConfig((CacheLoaderConfig)clc);
        clc.setFetchPersistentState(true);
        clmc.setShared(Boolean.valueOf(false));
        cfg.setCacheLoaderManagerConfig(clmc);
        return cfg;
    }

    public void test000(Method m) {
        Cache cache1 = this.cache(0, "onlyFetchPersistent");
        assert (!cache1.getConfiguration().isFetchInMemoryState());
        cache1.put((Object)("k-" + m.getName()), (Object)("v-" + m.getName()));
        Configuration cfg2 = this.createConfiguration(2);
        EmbeddedCacheManager cm2 = this.addClusterEnabledCacheManager();
        cm2.defineConfiguration("onlyFetchPersistent", cfg2);
        Cache cache2 = this.cache(1, "onlyFetchPersistent");
        assert (!cache2.getConfiguration().isFetchInMemoryState());
        assert (cache2.containsKey((Object)("k-" + m.getName())));
        assert (cache2.get((Object)("k-" + m.getName())).equals("v-" + m.getName()));
    }
}

