/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary;

import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.binary.AbstractBinaryStore;
import org.modeshape.jcr.value.binary.BinaryStoreException;

@ThreadSafe
public class InfinispanBinaryStore
extends AbstractBinaryStore {
    private String contentCacheName;
    private CacheContainer contentCacheContainer;
    private String cacheName;
    private CacheContainer cacheContainer;
    private Cache<?, ?> cache;
    private boolean ownCacheContainer;

    public InfinispanBinaryStore(String cacheName, CacheContainer cacheContainer) {
        this.cacheName = cacheName;
        this.cacheContainer = cacheContainer;
    }

    public void setContentCacheName(String cacheName) {
        this.contentCacheName = cacheName;
    }

    public void setContentCacheContainer(CacheContainer cacheContainer) {
        this.contentCacheContainer = cacheContainer;
    }

    @Override
    public void start() {
        if (this.cache != null) {
            if (this.cacheName == null) {
                this.cacheName = this.contentCacheName;
            }
            if (this.cacheContainer == null) {
                this.cacheContainer = this.contentCacheContainer;
                this.ownCacheContainer = false;
            } else {
                this.ownCacheContainer = true;
            }
            this.cache = this.cacheContainer.getCache(this.cacheName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        try {
            if (this.ownCacheContainer && this.cacheContainer instanceof EmbeddedCacheManager) {
                ((EmbeddedCacheManager)this.cacheContainer).stop();
            }
        }
        finally {
            this.cacheContainer = null;
            this.cacheName = null;
        }
    }

    public Cache<?, ?> getCache() {
        return this.cache;
    }

    @Override
    public BinaryValue storeValue(InputStream stream) throws BinaryStoreException {
        throw new BinaryStoreException("Not implemented");
    }

    @Override
    public InputStream getInputStream(BinaryKey key) throws BinaryStoreException {
        throw new BinaryStoreException("Not implemented");
    }

    @Override
    public void markAsUnused(Iterable<BinaryKey> keys) throws BinaryStoreException {
        throw new BinaryStoreException("Not implemented");
    }

    @Override
    public void removeValuesUnusedLongerThan(long minimumAge, TimeUnit unit) throws BinaryStoreException {
        throw new BinaryStoreException("Not implemented");
    }

    @Override
    public String getMimeType(BinaryValue binary, String name) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public String getExtractedText(BinaryValue source) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void storeExtractedText(BinaryValue source, String extractedText) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

