/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.FullContainerBox;
import java.io.IOException;

public class SampleDescriptionBox
extends FullContainerBox {
    public static final String TYPE = "stsd";

    public SampleDescriptionBox() {
        super(TYPE);
    }

    protected long getContentSize() {
        long size = 4L;
        for (Box box : this.boxes) {
            size += box.getSize();
        }
        return size;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        this.parseHeader(in, size);
        long entryCount = in.readUInt32();
        if (entryCount > Integer.MAX_VALUE) {
            throw new IOException("The parser cannot deal with more than Integer.MAX_VALUE subboxes");
        }
        long sp = in.position();
        int i = 0;
        while ((long)i < entryCount) {
            this.boxes.add(boxParser.parseBox(in, this, lastMovieFragmentBox));
            ++i;
        }
        if (in.position() - this.offset < size) {
            long length = size - (in.position() - this.offset);
            this.setDeadBytes(in.getSegment(in.position(), length));
        }
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.writeUInt32(this.boxes.size());
        for (Box boxe : this.boxes) {
            boxe.getBox(isos);
        }
    }
}

