/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.modeshape.common.text.UrlEncoder;
import org.modeshape.common.util.Base64;
import org.modeshape.common.util.StringUtil;
import org.modeshape.web.jcr.RepositoryManager;

abstract class AbstractHandler {
    protected static final String BASE64_ENCODING_SUFFIX = "/base64/";
    protected static final UrlEncoder URL_ENCODER = new UrlEncoder();
    public static final String EMPTY_REPOSITORY_NAME = "<default>";
    public static final String EMPTY_WORKSPACE_NAME = "<default>";

    AbstractHandler() {
    }

    protected Session getSession(HttpServletRequest request, String rawRepositoryName, String rawWorkspaceName) throws RepositoryException {
        assert (request != null);
        return RepositoryManager.getSession((HttpServletRequest)request, (String)this.repositoryNameFor(rawRepositoryName), (String)this.workspaceNameFor(rawWorkspaceName));
    }

    private String workspaceNameFor(String rawWorkspaceName) {
        String workspaceName = URL_ENCODER.decode(rawWorkspaceName);
        if ("<default>".equals(workspaceName)) {
            workspaceName = "";
        }
        return workspaceName;
    }

    private String repositoryNameFor(String rawRepositoryName) {
        String repositoryName = URL_ENCODER.decode(rawRepositoryName);
        if ("<default>".equals(repositoryName)) {
            repositoryName = "";
        }
        return repositoryName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String jsonEncodedStringFor(Value value) throws RepositoryException {
        if (value.getType() != 2) {
            return value.getString();
        }
        InputStream stream = value.getBinary().getStream();
        try {
            String string = Base64.encode((InputStream)stream);
            return string;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new RepositoryException((Throwable)e);
                }
            }
        }
    }

    protected String responseString(JSONObject object, HttpServletRequest request) throws JSONException {
        String acceptHeader = request.getHeader("Accept");
        if (StringUtil.isBlank((String)acceptHeader)) {
            return this.responseAsText(object);
        }
        if ((acceptHeader = acceptHeader.toLowerCase()).contains("application/json".toLowerCase())) {
            return this.responseAsApplicationJSON(object);
        }
        if (acceptHeader.contains("text/html".toLowerCase())) {
            return this.responseAsHTML(object);
        }
        return this.responseAsText(object);
    }

    private String responseAsText(JSONObject object) throws JSONException {
        return object.toString(2);
    }

    private String responseAsApplicationJSON(JSONObject object) {
        return object.toString();
    }

    private String responseAsHTML(JSONObject object) throws JSONException {
        String indentedString = object.toString(2);
        indentedString = indentedString.replaceAll("\n", "<br/>").replaceAll("\\\\", "").replaceAll("\\s", "&nbsp;");
        return "<code>" + indentedString + "</code>";
    }
}

