/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ReadCommittedEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.ForceWriteLockTest", enabled=false, description="mmarkus: email sent on 5 Sep '11 -> optimistic locking :: Flag.FORCE_WRITE_LOCK ")
public class ForceWriteLockTest
extends SingleCacheManagerTest {
    private TransactionManager tm;
    private AdvancedCache advancedCache;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createLocalCacheManager(true);
        this.advancedCache = cacheManager.getCache().getAdvancedCache();
        this.tm = TestingUtil.getTransactionManager((Cache)this.advancedCache);
        return cacheManager;
    }

    public void testWriteLockIsAcquired() throws Exception {
        this.advancedCache.put((Object)"k", (Object)"v");
        this.assertNotLocked((Cache)this.advancedCache, "k");
        this.tm.begin();
        this.advancedCache.withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK}).get((Object)"k");
        InvocationContext ic = this.advancedCache.getInvocationContextContainer().getInvocationContext(true);
        CacheEntry cacheEntry = (CacheEntry)ic.getLookedUpEntries().get("k");
        assert (cacheEntry instanceof ReadCommittedEntry && cacheEntry.isChanged());
        this.assertLocked((Cache)this.advancedCache, "k");
        this.tm.commit();
        this.assertNotLocked((Cache)this.advancedCache, "k");
    }
}

